/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.jxpath.JXPathContext;
import repast.simphony.integration.FileDef;
import repast.simphony.integration.JXPathUtils;

public class JXPathUtilsTest
extends TestCase {
    private Top rootObject;
    private JXPathContext rootContext;
    private JXPathContext subContext;
    private Object subObject;

    protected void setUp() throws Exception {
        this.rootObject = new Top();
        this.subObject = this.rootObject.bottom;
        this.subContext = JXPathUtils.createContext(this.subObject, true);
        this.rootContext = JXPathUtils.createRootContext(this.rootObject, true);
    }

    public void testCreateContext() {
        this.subContext = JXPathUtils.createContext(this.subObject, true);
        JXPathUtilsTest.assertTrue((boolean)this.subContext.isLenient());
        JXPathUtilsTest.assertSame((Object)this.subContext.getContextBean(), (Object)this.subObject);
    }

    public void testCreateRootContext() {
        this.rootContext = JXPathUtils.createRootContext(this.rootObject, true);
        JXPathUtilsTest.assertTrue((boolean)this.rootContext.isLenient());
        JXPathUtilsTest.assertSame((Object)this.rootObject, (Object)((FileDef)this.rootContext.getContextBean()).getFileDef());
    }

    public void testGetContext() {
        JXPathUtilsTest.assertSame((Object)this.subContext, (Object)JXPathUtils.getContext(this.rootContext, this.subContext, "asdf/asdf/asdf"));
        JXPathUtilsTest.assertSame((Object)this.subContext, (Object)JXPathUtils.getContext(this.rootContext, this.subContext, "asdf"));
        JXPathUtilsTest.assertSame((Object)this.rootContext, (Object)JXPathUtils.getContext(this.rootContext, this.subContext, "/asdf/asdf"));
        JXPathUtilsTest.assertSame((Object)this.rootContext, (Object)JXPathUtils.getContext(this.rootContext, this.subContext, "/asdf"));
        JXPathUtilsTest.assertSame((Object)this.rootContext, (Object)JXPathUtils.getContext(this.rootContext, null, "/asdf"));
        JXPathUtilsTest.assertSame((Object)this.subContext, (Object)JXPathUtils.getContext(null, this.subContext, "/asdf"));
        JXPathUtilsTest.assertSame((Object)this.rootContext, (Object)JXPathUtils.getContext(this.rootContext, null, "asdf"));
        JXPathUtilsTest.assertSame((Object)this.subContext, (Object)JXPathUtils.getContext(null, this.subContext, "asdf"));
    }

    public void testFixPath() {
        String correctPath = "/fileDef/asdf/eras9/asdfn";
        String badPath = "/fileDef/asdf/eras9/asdfn";
        JXPathUtilsTest.assertEquals((String)correctPath, (String)JXPathUtils.fixPath(badPath));
        JXPathUtilsTest.assertEquals((String)correctPath, (String)JXPathUtils.fixPath(correctPath));
    }

    public void testGetXPathNode() {
        JXPathUtilsTest.assertEquals((Object)this.rootContext.getContextBean(), (Object)JXPathUtils.getXPathNode(this.rootContext, this.subContext, "/"));
        JXPathUtilsTest.assertEquals((Object)this.subObject, (Object)JXPathUtils.getXPathNode(this.rootContext, this.rootContext, "fileDef/bottom"));
        JXPathUtilsTest.assertEquals((Object)this.subObject, (Object)JXPathUtils.getXPathNode(this.rootContext, this.subContext, "/fileDef/bottom"));
        JXPathUtilsTest.assertNull((Object)JXPathUtils.getXPathNode(this.rootContext, this.subContext, "/non-existantfield"));
    }

    public void testGetXPathNodeExcept() {
        try {
            JXPathUtils.getXPathNode(null, null, "/fileDef");
            JXPathUtilsTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetXPathNodesExcept() {
        try {
            JXPathUtils.getXPathNodes(null, null, "/fileDef");
            JXPathUtilsTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static ArrayList toList(Object obj) {
        ArrayList<Object> foo = new ArrayList<Object>();
        foo.add(obj);
        return foo;
    }

    public void testGetXPathNodes() {
        JXPathUtilsTest.assertEquals((Object)JXPathUtilsTest.toList(this.rootContext.getContextBean()), JXPathUtils.getXPathNodes(this.rootContext, this.subContext, "/"));
        JXPathUtilsTest.assertEquals((Object)JXPathUtilsTest.toList(this.subObject), JXPathUtils.getXPathNodes(this.rootContext, this.rootContext, "fileDef/bottom"));
        JXPathUtilsTest.assertEquals((Object)JXPathUtilsTest.toList(this.subObject), JXPathUtils.getXPathNodes(this.rootContext, this.subContext, "/fileDef/bottom"));
        JXPathUtilsTest.assertTrue((boolean)JXPathUtils.getXPathNodes(this.rootContext, this.subContext, "/non-existantfield").isEmpty());
    }

    public class Top {
        Object bottom = "bottom";

        public Object getBottom() {
            return this.bottom;
        }
    }
}

