/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import junit.framework.TestCase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import repast.simphony.integration.DataContent;
import repast.simphony.integration.JDOMXPathUtils;

public class JDOMXPathUtilsTest
extends TestCase {
    private Element subElement;
    private Element rootElement;
    private Document document;
    private DataContent subContent;
    private DataContent rootContent;

    protected void setUp() throws Exception {
        this.document = new Document();
        this.rootElement = new Element("root");
        this.rootContent = new DataContent("rootContent");
        this.rootElement.addContent((Content)this.rootContent);
        this.document.setRootElement(this.rootElement);
        this.subElement = new Element("sub");
        this.subContent = new DataContent("subContent");
        this.subElement.addContent((Content)this.subContent);
        this.rootElement.addContent((Content)this.subElement);
    }

    public void testGetValue() {
        JDOMXPathUtilsTest.assertNull((Object)JDOMXPathUtils.getValue(null));
        String val = "val";
        JDOMXPathUtilsTest.assertEquals((Object)val, (Object)JDOMXPathUtils.getValue(val));
        Element element = new Element("element");
        element.addContent((Content)new DataContent(val));
        JDOMXPathUtilsTest.assertEquals((Object)val, (Object)JDOMXPathUtils.getValue(element));
        Element emptyElement = new Element("element");
        JDOMXPathUtilsTest.assertNull((Object)JDOMXPathUtils.getValue(emptyElement));
    }

    public void testEvalXPaths() throws JDOMException {
        JDOMXPathUtilsTest.assertEquals((Object)this.subElement, JDOMXPathUtils.evalXPaths("/root/sub", this.rootElement).get(0));
        JDOMXPathUtilsTest.assertEquals((Object)this.rootElement, JDOMXPathUtils.evalXPaths("/root", this.rootElement).get(0));
    }

    public void testEvalXPath() throws JDOMException {
        JDOMXPathUtilsTest.assertEquals((Object)this.subElement, (Object)JDOMXPathUtils.evalXPath("/root/sub", this.rootElement));
        JDOMXPathUtilsTest.assertEquals((Object)this.rootElement, (Object)JDOMXPathUtils.evalXPath("/root", this.rootElement));
        JDOMXPathUtilsTest.assertNull((Object)JDOMXPathUtils.evalXPath("/rootasdfasf", this.rootElement));
    }

    public void testEvalXPathStrings() throws JDOMException {
        JDOMXPathUtilsTest.assertEquals((String)this.subContent.getValue(), (String)JDOMXPathUtils.evalXPathStrings("/root/sub", this.rootElement).get(0));
        JDOMXPathUtilsTest.assertEquals((String)this.rootContent.getValue(), (String)JDOMXPathUtils.evalXPathStrings("/root", this.rootElement).get(0));
    }

    public void testEvalXPathString() throws JDOMException {
        JDOMXPathUtilsTest.assertEquals((String)this.subContent.getValue(), (String)JDOMXPathUtils.evalXPathString("/root/sub", this.rootElement));
        JDOMXPathUtilsTest.assertEquals((String)this.rootContent.getValue(), (String)JDOMXPathUtils.evalXPathString("/root", this.rootElement));
    }
}

