/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import repast.simphony.util.SystemConstants;

public enum EscapeConverter {
    NONE("none"){

        @Override
        public String convert(String string) {
            return string;
        }
    }
    ,
    SYSTEM("system"){

        @Override
        public String convert(String string) {
            String retVal = SystemConstants.LINE_SEPARATOR.equals("\r\n") ? WINDOWS.convert(string) : (SystemConstants.LINE_SEPARATOR.equals("\n") ? UNIX.convert(string) : string.replace("\\\\n", SystemConstants.LINE_SEPARATOR));
            return 2.convertNonNewlineEscapes(retVal);
        }
    }
    ,
    WINDOWS("windows"){

        @Override
        public String convert(String string) {
            return 3.convertNonNewlineEscapes(string.replaceAll("\\\\n", "\r\n"));
        }
    }
    ,
    UNIX("unix"){

        @Override
        public String convert(String string) {
            return 4.convertNonNewlineEscapes(string.replaceAll("\\\\n", "\n"));
        }
    };

    public final String tag;

    private EscapeConverter(String descriptor) {
        this.tag = descriptor;
    }

    public static EscapeConverter getNewLineConverter(String handleType) {
        EscapeConverter[] escapeConverterArray = EscapeConverter.values();
        int n = escapeConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            EscapeConverter handler = escapeConverterArray[n2];
            if (handler.tag.equalsIgnoreCase(handleType)) {
                return handler;
            }
            ++n2;
        }
        return NONE;
    }

    public static String convertNonNewlineEscapes(String string) {
        return string.replaceAll("\\\\t", "\t");
    }

    public abstract String convert(String var1);

    /* synthetic */ EscapeConverter(String string, int n, String string2, EscapeConverter escapeConverter) {
        this(string2);
    }
}

