/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import repast.simphony.integration.MessageCenterHandler;
import repast.simphony.integration.Queryable;
import simphony.util.messages.Log4jMessageListener;
import simphony.util.messages.MessageCenter;

public class DataFileUtils {
    public static final String IGNORE_DATA_TARGET = "null";
    public static final String SCHEMA_FILE_NAME = "datadescriptor.xsd";
    public static final String GENERATED_SCHEMA_FILE_NAME = "dataDescriptorEcore.xsd";
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(DataFileUtils.class);
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String GENERATED_EXT = "filedescription";

    public static Document loadDescriptor(String fileName) throws JDOMException, IOException {
        try {
            InputStream fileInStream;
            SAXBuilder docBuilder = new SAXBuilder();
            docBuilder.setErrorHandler((ErrorHandler)new MessageCenterHandler());
            docBuilder.setValidation(true);
            docBuilder.setProperty(JAXP_SCHEMA_LANGUAGE, (Object)W3C_XML_SCHEMA);
            if (fileName.endsWith(GENERATED_EXT)) {
                String line;
                LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                while ((line = reader.readLine()) != null) {
                    if (line.contains("DataDescriptorSchema:DocumentRoot")) continue;
                    byteStream.write(line.getBytes());
                }
                fileInStream = new ByteArrayInputStream(byteStream.toByteArray());
            } else {
                fileInStream = new FileInputStream(fileName);
            }
            InputStream schemaStream = DataFileUtils.class.getResourceAsStream(SCHEMA_FILE_NAME);
            if (schemaStream == null) {
                RuntimeException ex = new RuntimeException("Error, the data file schema file(datadescriptor.xsd) could not be fetched as a resource Stream.");
                msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                throw ex;
            }
            docBuilder.setProperty(JAXP_SCHEMA_SOURCE, (Object)schemaStream);
            return docBuilder.build(fileInStream);
        }
        catch (JDOMException ex) {
            msgCenter.error((Object)("Error loading XML descriptor file; could not find the descriptor XML file(" + fileName + ")"), (Throwable)ex, new Object[0]);
            throw ex;
        }
    }

    public static String findBestValue(Queryable queryable, Element nodeToHandle, String attributeName, boolean useXPath) {
        if (nodeToHandle == null || nodeToHandle.getAttribute(attributeName) == null) {
            return null;
        }
        String nodeValue = nodeToHandle.getAttribute(attributeName).getValue();
        if (useXPath) {
            try {
                Object xpathResult = queryable.selectNode(nodeValue);
                if (xpathResult != null) {
                    return queryable.getValue(xpathResult).toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nodeValue.toString();
    }

    public static Object findExplicitTargetParent(Queryable queryable, String targetPath) {
        if (targetPath == null) {
            return null;
        }
        int lastSlash = targetPath.lastIndexOf("/");
        if (lastSlash <= 0) {
            return null;
        }
        Object parent = queryable.selectNode(targetPath.substring(0, lastSlash));
        return parent;
    }

    public static String getName(String targetPath) {
        if (targetPath == null) {
            return null;
        }
        int lastSlash = targetPath.lastIndexOf("/");
        if (lastSlash <= 0) {
            return targetPath;
        }
        return targetPath.substring(lastSlash + 1, targetPath.length());
    }

    public static boolean isGarbage(String string) {
        return string == null || string.equals("");
    }

    public static String findBestValue(Queryable queryable, Element element, String attributeName) {
        return DataFileUtils.findBestValue(queryable, element, attributeName, true);
    }

    public static void main(String[] args) {
        Log4jMessageListener.loadDefaultSettings();
        try {
            DataFileUtils.loadDescriptor("Untitled.datadescriptor");
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

