/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import simphony.util.messages.MessageCenter;

public class CustomExecute
extends DefaultExecutor {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(CustomExecute.class);
    private File workingDirectory;
    private CommandLine commandLine;
    private Map environment;

    public void setWorkingDirectory(File wd) {
        super.setWorkingDirectory(wd);
        this.workingDirectory = wd;
    }

    public Process spawnAndReturnProcess() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new IOException(this.workingDirectory + " doesn't exist.");
        }
        Process process = this.launch(this.commandLine, this.environment, this.workingDirectory);
        if (OS.isFamilyWindows()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                msgCenter.debug((Object)"interruption in the sleep after having spawned a process", new Object[0]);
            }
        }
        OutputStream dummyOut = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        PumpStreamHandler streamHandler = new PumpStreamHandler(dummyOut);
        streamHandler.setProcessErrorStream(process.getErrorStream());
        streamHandler.setProcessOutputStream(process.getInputStream());
        streamHandler.start();
        process.getOutputStream().close();
        msgCenter.debug((Object)("spawned process " + process.toString()), new Object[0]);
        return process;
    }

    public void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }
}

