/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.context.Context;
import repast.simphony.space.gis.Geography;
import simphony.util.messages.MessageCenter;

public class ShapefileLoader<T> {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(ShapefileLoader.class);
    private static Map<Class, Class> primToObject = new HashMap<Class, Class>();
    private MathTransform transform;
    private Geography geography;
    private Context context;
    private Map<String, Method> attributeMethodMap = new HashMap<String, Method>();
    private Class agentClass;
    private Iterator<SimpleFeature> featureIterator;

    static {
        primToObject.put(Integer.TYPE, Integer.class);
        primToObject.put(Long.TYPE, Long.class);
        primToObject.put(Double.TYPE, Double.class);
        primToObject.put(Float.TYPE, Float.class);
        primToObject.put(Boolean.TYPE, Boolean.class);
        primToObject.put(Byte.TYPE, Byte.class);
        primToObject.put(Character.TYPE, Character.class);
    }

    /*
     * Loose catch block
     */
    public ShapefileLoader(Class<T> clazz, URL shapefile, Geography geography, Context context) {
        this.geography = geography;
        this.agentClass = clazz;
        this.context = context;
        ShapefileDataStore store = null;
        SimpleFeatureIterator iter = null;
        try {
            try {
                PropertyDescriptor[] pds;
                BeanInfo info = Introspector.getBeanInfo(clazz, Object.class);
                HashMap<String, Method> methodMap = new HashMap<String, Method>();
                PropertyDescriptor[] propertyDescriptorArray = pds = info.getPropertyDescriptors();
                int n = pds.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = propertyDescriptorArray[n2];
                    if (pd.getWriteMethod() != null) {
                        methodMap.put(pd.getName().toLowerCase(), pd.getWriteMethod());
                    }
                    ++n2;
                }
                store = new ShapefileDataStore(shapefile);
                SimpleFeatureType schema = store.getSchema(store.getTypeNames()[0]);
                AttributeType type = schema.getType(0);
                String name = type.getName().getLocalPart();
                this.initTransform(geography, type);
                int i = 1;
                int n3 = schema.getAttributeCount();
                while (i < n3) {
                    type = schema.getType(i);
                    name = type.getName().getLocalPart();
                    Method method = (Method)methodMap.get(name.toLowerCase());
                    if (method == null) {
                        method = (Method)methodMap.get(name.replace("_", "").toLowerCase());
                    }
                    if (method != null && this.isCompatible(method.getParameterTypes()[0], type.getBinding())) {
                        this.attributeMethodMap.put(name, method);
                    }
                    ++i;
                }
                iter = store.getFeatureSource().getFeatures().features();
                ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                while (iter.hasNext()) {
                    features.add((SimpleFeature)iter.next());
                }
                this.featureIterator = features.iterator();
            }
            catch (IntrospectionException ex) {
                msg.error((Object)"Error while introspecting class", (Throwable)ex, new Object[0]);
                iter.close();
                store.dispose();
            }
            catch (IOException e) {
                msg.error((Object)String.format("Error opening shapefile '%S'", shapefile), (Throwable)e, new Object[0]);
                iter.close();
                store.dispose();
            }
            catch (FactoryException e) {
                msg.error((Object)String.format("Error creating transform between shapefile CRS and Geography CRS", new Object[0]), (Throwable)e, new Object[0]);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                iter.close();
                store.dispose();
            }
        }
        finally {
            iter.close();
            store.dispose();
        }
    }

    private boolean isCompatible(Class methodParam, Class attributeType) {
        if (methodParam.equals(attributeType)) {
            return true;
        }
        Class clazz = primToObject.get(methodParam);
        if (clazz != null) {
            return clazz.equals(attributeType);
        }
        return false;
    }

    private void initTransform(Geography geography, AttributeType type) throws FactoryException {
        GeometryType gType = (GeometryType)type;
        if (geography != null) {
            try {
                this.transform = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(gType.getCoordinateReferenceSystem(), geography.getCRS()).getMathTransform();
            }
            catch (OperationNotFoundException ex) {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)gType.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)geography.getCRS(), (boolean)true);
            }
        }
    }

    public void load() {
        while (this.hasNext()) {
            this.next();
        }
    }

    public T next() {
        T obj = null;
        try {
            obj = this.agentClass.newInstance();
            obj = this.processNext(obj);
        }
        catch (InstantiationException e) {
            msg.error((Object)"Error creating agent instance from class", (Throwable)e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            msg.error((Object)"Error creating agent instance from class", (Throwable)e, new Object[0]);
        }
        return obj;
    }

    private T processNext(T obj) {
        try {
            SimpleFeature feature = this.featureIterator.next();
            obj = this.fillAgent(feature, obj);
            if (!this.context.contains(obj)) {
                this.context.add(obj);
            }
            if (this.geography != null) {
                this.geography.move(obj, JTS.transform((Geometry)((Geometry)feature.getDefaultGeometry()), (MathTransform)this.transform));
            }
            return obj;
        }
        catch (IllegalAccessException e) {
            msg.error((Object)"Error setting agent property from feature attribute", (Throwable)e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            msg.error((Object)"Error setting agent property from feature attribute", (Throwable)e, new Object[0]);
        }
        catch (TransformException e) {
            msg.error((Object)"Error transforming feature geometry to geography's CRS", (Throwable)e, new Object[0]);
        }
        return null;
    }

    public T nextWithArgs(Object ... constructorArgs) throws IllegalArgumentException {
        Constructor constructor = this.findConstructor(constructorArgs);
        if (constructor == null) {
            throw new IllegalArgumentException("Unable to find matching constructor for arguments");
        }
        try {
            Object obj = constructor.newInstance(constructorArgs);
            return this.processNext(obj);
        }
        catch (InstantiationException e) {
            msg.error((Object)"Error creating agent instance from class", (Throwable)e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            msg.error((Object)"Error creating agent instance from class", (Throwable)e, new Object[0]);
        }
        catch (InvocationTargetException e) {
            msg.error((Object)"Error creating agent instance from class", (Throwable)e, new Object[0]);
        }
        return null;
    }

    public T next(T obj) {
        return this.processNext(obj);
    }

    private Constructor findConstructor(Object[] constructorArgs) {
        Class[] args = new Class[constructorArgs.length];
        int i = 0;
        Object[] objectArray = constructorArgs;
        int n = constructorArgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            args[i++] = obj.getClass();
            ++n2;
        }
        objectArray = this.agentClass.getConstructors();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object constructor = objectArray[n2];
            Class<?>[] params = ((Constructor)constructor).getParameterTypes();
            if (params.length == args.length) {
                boolean pass = true;
                i = 0;
                while (i < args.length) {
                    if (!this.isCompatible(params[i], args[i])) {
                        pass = false;
                        break;
                    }
                    ++i;
                }
                if (pass) {
                    return constructor;
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean hasNext() {
        return this.featureIterator.hasNext();
    }

    private T fillAgent(SimpleFeature feature, T agent) throws IllegalAccessException, InvocationTargetException {
        for (String attribName : this.attributeMethodMap.keySet()) {
            Object val = feature.getAttribute(attribName);
            Method write = this.attributeMethodMap.get(attribName);
            write.invoke(agent, val);
        }
        return agent;
    }
}

