/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import javax.measure.unit.SI;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.UTMFinder;

public class GeometryUtils {
    private static DefaultCoordinateOperationFactory cFactory = new DefaultCoordinateOperationFactory();

    public static Geometry generateBuffer(Geography geography, Geometry geom, double distance) {
        boolean convert = !geography.getUnits(0).equals((Object)SI.METER);
        CoordinateReferenceSystem utm = null;
        Geometry buffer = null;
        CoordinateReferenceSystem crs = geography.getCRS();
        Geometry g2 = geom;
        try {
            if (convert) {
                utm = UTMFinder.getUTMFor(geom, crs);
                g2 = JTS.transform((Geometry)geom, (MathTransform)cFactory.createOperation(crs, utm).getMathTransform());
            }
            buffer = g2.buffer(distance);
            if (convert) {
                buffer = JTS.transform((Geometry)buffer, (MathTransform)cFactory.createOperation(utm, crs).getMathTransform());
            }
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}

