/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.query.space.gis.ContainsQuery;
import repast.simphony.query.space.gis.GeographyWithin;
import repast.simphony.query.space.gis.IntersectsQuery;
import repast.simphony.query.space.gis.TouchesQuery;
import repast.simphony.query.space.gis.WithinQuery;
import repast.simphony.query.space.projection.Within;
import repast.simphony.space.gis.Car;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.House;
import repast.simphony.space.gis.Layer;
import repast.simphony.space.gis.RandomGISAdder;
import repast.simphony.space.gis.Road;
import repast.simphony.space.gis.Shed;
import repast.simphony.space.gis.UTMFinder;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionListener;
import repast.simphony.space.projection.ProjectionPredicate;

public class GeographyTest
extends TestCase {
    private Geography<Object> geography;
    private Context<Object> town;
    private House[] houses = new House[10];
    private Car[] cars = new Car[10];

    public void setUp() {
        this.town = new DefaultContext();
        int i = 0;
        while (i < 10) {
            House house = new House("Owner" + i, "1Main St", "Anytown", "Anystate");
            this.town.add((Object)house);
            this.houses[i] = house;
            ++i;
        }
        i = 0;
        while (i < 10) {
            Car car = new Car("Saturn", "SW1", i, "Brown");
            this.town.add((Object)car);
            this.cars[i] = car;
            ++i;
        }
        GeographyParameters params = new GeographyParameters();
        this.geography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("AnyTown", this.town, params);
    }

    public void testUTMZone() {
        short val = UTMFinder.determineZone(48.3, -114.26667);
        GeographyTest.assertEquals((int)11, (int)val);
        val = UTMFinder.determineZone(45.8, -108.5333);
        GeographyTest.assertEquals((int)12, (int)val);
        val = UTMFinder.determineZone(45.8, 174.0);
        GeographyTest.assertEquals((int)60, (int)val);
        val = UTMFinder.determineZone(45.8, 173.999);
        GeographyTest.assertEquals((int)59, (int)val);
        val = UTMFinder.determineZone(45.8, -180.0);
        GeographyTest.assertEquals((int)1, (int)val);
        val = UTMFinder.determineZone(45.8, 180.0);
        GeographyTest.assertEquals((int)60, (int)val);
    }

    public void testGetLayerNames() {
        Collection<String> layerNames = this.geography.getLayerNames();
        HashSet<String> expected = new HashSet<String>();
        expected.add(String.valueOf(House.class.getName()) + ".FeatureType");
        expected.add(String.valueOf(Car.class.getName()) + ".FeatureType");
        for (String layer : layerNames) {
            GeographyTest.assertTrue((boolean)expected.remove(layer));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testMove() {
        GeometryFactory fac = new GeometryFactory();
        Coordinate coord = new Coordinate(-87.2, 42.1);
        Point geom = fac.createPoint(coord);
        GeographyTest.assertNull((Object)this.geography.getGeometry(this.houses[0]));
        this.geography.move(this.houses[0], (Geometry)geom);
        GeographyTest.assertEquals((Object)geom, (Object)this.geography.getGeometry(this.houses[0]));
        geom = this.geography.getGeometry(this.houses[0]);
        geom.getCoordinate().x += 10.0;
        double x = geom.getCoordinate().x;
        this.geography.move((Object)this, (Geometry)geom);
        GeographyTest.assertEquals((Object)x, (Object)this.geography.getGeometry((Object)this.houses[0]).getCoordinate().x);
    }

    public void testDisplacementMove() {
        GeometryFactory fac = new GeometryFactory();
        Coordinate coord = new Coordinate(12.0, 32.0);
        Point geom = fac.createPoint(coord);
        this.geography.move(this.cars[0], (Geometry)geom);
        GeographyTest.assertEquals((Object)geom, (Object)this.geography.getGeometry(this.cars[0]));
        geom = this.geography.moveByDisplacement(this.cars[0], -5.5, 0.32);
        GeographyTest.assertTrue((boolean)fac.createPoint(new Coordinate(6.5, 32.32)).equalsExact((Geometry)geom));
    }

    public void testVectorMove() {
        GeometryFactory fac = new GeometryFactory();
        Coordinate coord = new Coordinate(12.0, 32.0);
        Point geom = fac.createPoint(coord);
        this.geography.move(this.cars[0], (Geometry)geom);
        GeographyTest.assertEquals((Object)geom, (Object)this.geography.getGeometry(this.cars[0]));
        Geometry newGeom = this.geography.moveByVector(this.cars[0], 10000.0, Math.toRadians(90.0));
        GeodeticCalculator calc = new GeodeticCalculator(this.geography.getCRS());
        calc.setStartingGeographicPoint(coord.x, coord.y);
        calc.setDirection(0.0, 10000.0);
        Point2D pt = calc.getDestinationGeographicPoint();
        GeographyTest.assertEquals((Object)newGeom.getCoordinate().x, (Object)pt.getX());
        GeographyTest.assertEquals((Object)newGeom.getCoordinate().y, (Object)pt.getY());
        calc.setStartingGeographicPoint(geom.getCoordinate().x, geom.getCoordinate().y);
        calc.setDestinationGeographicPoint(newGeom.getCoordinate().x, newGeom.getCoordinate().y);
        System.out.println("calc.getOrthodromicDistance() = " + calc.getOrthodromicDistance());
    }

    public void testGetLayer() {
        Layer layer = this.geography.getLayer(Car.class);
        GeographyTest.assertEquals(Car.class, layer.getAgentType());
    }

    public void testGetGeometry() {
        GeometryFactory fac = new GeometryFactory();
        Coordinate coord = new Coordinate(-87.2, 42.1);
        Point geom = fac.createPoint(coord);
        this.geography.move(this.houses[0], (Geometry)geom);
        GeographyTest.assertEquals((Object)geom, (Object)this.geography.getGeometry(this.houses[0]));
    }

    public void testGetObjectsAt() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        this.geography.move(this.cars[0], this.geography.getGeometry(this.cars[2]));
        this.geography.move(this.houses[0], this.geography.getGeometry(this.cars[2]));
        Envelope env = new Envelope(1.5, -1.0, 0.5, 2.5);
        HashSet<Object> resultSet = new HashSet<Object>();
        resultSet.add(this.cars[0]);
        resultSet.add(this.cars[2]);
        resultSet.add(this.cars[3]);
        resultSet.add(this.cars[4]);
        resultSet.add(this.cars[5]);
        resultSet.add(this.houses[0]);
        for (Object object : this.geography.getObjectsWithin(env)) {
            GeographyTest.assertTrue((boolean)resultSet.remove(object));
        }
        GeographyTest.assertEquals((int)0, (int)resultSet.size());
        resultSet.add(this.cars[0]);
        resultSet.add(this.cars[2]);
        resultSet.add(this.cars[3]);
        resultSet.add(this.cars[4]);
        resultSet.add(this.cars[5]);
        for (Object object : this.geography.getObjectsWithin(env, Car.class)) {
            GeographyTest.assertTrue((boolean)resultSet.remove(object));
        }
        GeographyTest.assertEquals((int)0, (int)resultSet.size());
        resultSet.add(this.houses[0]);
        for (Object object : this.geography.getObjectsWithin(env, House.class)) {
            GeographyTest.assertTrue((boolean)resultSet.remove(object));
        }
        GeographyTest.assertEquals((int)0, (int)resultSet.size());
    }

    public void testContainsQuery() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        Shed shed = new Shed();
        this.town.add((Object)shed);
        Coordinate[] coords = new Coordinate[]{new Coordinate(-1.0, 0.5), new Coordinate(1.5, 0.5), new Coordinate(1.5, 1.5), new Coordinate(-1.0, 1.5), new Coordinate(-1.0, 0.5)};
        Polygon geom = fac.createPolygon(fac.createLinearRing(coords), null);
        this.geography.move(shed, (Geometry)geom);
        HashSet<Car> expected = new HashSet<Car>();
        expected.add(this.cars[2]);
        expected.add(this.cars[3]);
        ContainsQuery<Shed> query = new ContainsQuery<Shed>(this.geography, shed);
        for (Object obj : query.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
        HashSet<Car> filterSet = new HashSet<Car>();
        filterSet.add(this.cars[0]);
        for (Object obj : query.query(filterSet)) {
            GeographyTest.fail();
        }
        filterSet.clear();
        filterSet.add(this.cars[2]);
        expected.add(this.cars[2]);
        for (Object obj : query.query(filterSet)) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testWithinQuery() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        Shed shed = new Shed();
        this.town.add((Object)shed);
        Coordinate[] coords = new Coordinate[]{new Coordinate(-1.0, 0.5), new Coordinate(1.5, 0.5), new Coordinate(1.5, 1.5), new Coordinate(-1.0, 1.5), new Coordinate(-1.0, 0.5)};
        Polygon geom = fac.createPolygon(fac.createLinearRing(coords), null);
        this.geography.move(shed, (Geometry)geom);
        HashSet<Shed> expected = new HashSet<Shed>();
        expected.add(shed);
        WithinQuery<Car> query = new WithinQuery<Car>(this.geography, this.cars[2]);
        for (Object obj : query.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
        HashSet<Shed> filterSet = new HashSet<Shed>();
        for (Object obj : query.query(filterSet)) {
            GeographyTest.fail();
        }
        filterSet.clear();
        filterSet.add(shed);
        expected.add(shed);
        for (Object obj : query.query(filterSet)) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testWithinPredicate() {
        GeometryFactory fac = new GeometryFactory();
        Shed billings = new Shed("Billings");
        Coordinate coord = new Coordinate(-108.5333, 45.8);
        Point geom = fac.createPoint(coord);
        this.geography.move(billings, (Geometry)geom);
        Shed bozeman = new Shed("bozeman");
        coord = new Coordinate(-111.15, 45.78333);
        geom = fac.createPoint(coord);
        this.geography.move(bozeman, (Geometry)geom);
        Within within = new Within((Object)billings, (Object)bozeman, 204000.0);
        GeographyTest.assertTrue((boolean)this.geography.evaluate((ProjectionPredicate)within));
        within = new Within((Object)billings, (Object)bozeman, 201000.0);
        GeographyTest.assertFalse((boolean)this.geography.evaluate((ProjectionPredicate)within));
    }

    public void testWithinDistance() throws TransformException {
        GeometryFactory fac = new GeometryFactory();
        Shed billings = new Shed("Billings");
        Coordinate coord = new Coordinate(-108.5333, 45.8);
        Point geom = fac.createPoint(coord);
        this.geography.move(billings, (Geometry)geom);
        Shed kalispell = new Shed("Kalispell");
        coord = new Coordinate(-114.26667, 48.3);
        geom = fac.createPoint(coord);
        this.geography.move(kalispell, (Geometry)geom);
        Shed bozeman = new Shed("bozeman");
        coord = new Coordinate(-111.15, 45.78333);
        geom = fac.createPoint(coord);
        this.geography.move(bozeman, (Geometry)geom);
        GeographyWithin within = new GeographyWithin(this.geography, 220000.0, billings);
        HashSet<Shed> expected = new HashSet<Shed>();
        expected.add(bozeman);
        for (Object obj : within.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
        within = new GeographyWithin(this.geography, 1000.0, this.geography.getGeometry(billings));
        expected = new HashSet();
        expected.add(billings);
        for (Object obj : within.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        within = new GeographyWithin(this.geography, 1000.0, billings);
        GeographyTest.assertTrue((!within.query().iterator().hasNext() ? 1 : 0) != 0);
        within = new GeographyWithin(this.geography, 520000.0, kalispell);
        expected = new HashSet();
        expected.add(billings);
        expected.add(bozeman);
        for (Object obj : within.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testIntersectsQuery() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        Shed shed = new Shed();
        this.town.add((Object)shed);
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.5), new Coordinate(1.5, 0.5), new Coordinate(1.5, 1.5), new Coordinate(0.0, 1.5), new Coordinate(0.0, 0.5)};
        Polygon geom = fac.createPolygon(fac.createLinearRing(coords), null);
        this.geography.move(shed, (Geometry)geom);
        HashSet<Shed> expected = new HashSet<Shed>();
        expected.add(shed);
        IntersectsQuery<Car> query = new IntersectsQuery<Car>(this.geography, this.cars[2]);
        for (Object obj : query.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
        HashSet<Shed> filterSet = new HashSet<Shed>();
        for (Object obj : query.query(filterSet)) {
            GeographyTest.fail();
        }
        filterSet.clear();
        filterSet.add(shed);
        expected.add(shed);
        for (Object obj : query.query(filterSet)) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testTouches() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        Shed shed = new Shed();
        this.town.add((Object)shed);
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.5), new Coordinate(1.5, 0.5), new Coordinate(1.5, 1.5), new Coordinate(0.0, 1.5), new Coordinate(0.0, 0.5)};
        Polygon geom = fac.createPolygon(fac.createLinearRing(coords), null);
        this.geography.move(shed, (Geometry)geom);
        Road road = new Road();
        LineString rg = fac.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 0.5)});
        this.geography.move(road, (Geometry)rg);
        HashSet<Object> expected = new HashSet<Object>();
        expected.add(shed);
        expected.add(this.cars[0]);
        TouchesQuery<Road> query = new TouchesQuery<Road>(this.geography, road);
        for (Object obj : query.query()) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
        HashSet<Shed> filterSet = new HashSet<Shed>();
        for (Object obj : query.query(filterSet)) {
            GeographyTest.fail();
        }
        filterSet.clear();
        filterSet.add(shed);
        expected.add(shed);
        for (Object obj : query.query(filterSet)) {
            GeographyTest.assertTrue((boolean)expected.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)expected.size());
    }

    public void testRemove() {
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 2) {
                Car car = this.cars[i++];
                Coordinate coord = new Coordinate((double)x, (double)y);
                Point geom = fac.createPoint(coord);
                this.geography.move(car, (Geometry)geom);
                ++x;
            }
            ++y;
        }
        this.geography.move(this.cars[0], this.geography.getGeometry(this.cars[2]));
        this.town.remove((Object)this.cars[2]);
        Envelope env = new Envelope(1.5, -1.0, 0.5, 2.5);
        HashSet<Car> carSet = new HashSet<Car>();
        carSet.add(this.cars[0]);
        carSet.add(this.cars[3]);
        carSet.add(this.cars[4]);
        carSet.add(this.cars[5]);
        for (Object obj : this.geography.getObjectsWithin(env)) {
            GeographyTest.assertTrue((boolean)carSet.remove(obj));
        }
        GeographyTest.assertEquals((int)0, (int)carSet.size());
    }

    public void testSetCRSString() throws FactoryException, TransformException {
        GeometryFactory fac = new GeometryFactory();
        Coordinate coord = new Coordinate(-87.2, 42.1);
        Point geom = fac.createPoint(coord);
        this.geography.move(this.houses[0], (Geometry)geom);
        CoordinateReferenceSystem crs = this.geography.getCRS();
        this.geography.setCRS("epsg:26971");
        GeographyTest.assertEquals((String)"EPSG:NAD83 / Illinois East", (String)this.geography.getCRS().getName().toString());
        Geometry newGeom = this.geography.getGeometry(this.houses[0]);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)CRS.decode((String)"epsg:26971"));
        Geometry tGeom = JTS.transform((Geometry)geom, (MathTransform)transform);
        GeographyTest.assertEquals((Object)newGeom.getCoordinate().x, (Object)tGeom.getCoordinate().x);
        GeographyTest.assertEquals((Object)newGeom.getCoordinate().y, (Object)tGeom.getCoordinate().y);
    }

    public void testGetCRS() {
        GeographyTest.assertEquals((String)"WGS84(DD)", (String)this.geography.getCRS().getName().toString());
    }

    public void testGetAdder() {
        GeographyTest.assertEquals((String)"SimpleAdder", (String)this.geography.getAdder().getClass().getSimpleName());
    }

    public void testSetAdder() {
        this.geography.setAdder(new RandomGISAdder(new GeometryFactory().toGeometry(new Envelope(0.0, 100.0, 0.0, 4.0))));
        GeographyTest.assertEquals((String)"RandomGISAdder", (String)this.geography.getAdder().getClass().getSimpleName());
        this.town.remove((Object)this.cars[0]);
        this.town.add((Object)this.cars[0]);
        Geometry geometry = this.geography.getGeometry(this.cars[0]);
        GeographyTest.assertTrue((geometry != null ? 1 : 0) != 0);
        GeographyTest.assertTrue((geometry.getCoordinate().x >= 0.0 && geometry.getCoordinate().x <= 100.0 ? 1 : 0) != 0);
        GeographyTest.assertTrue((geometry.getCoordinate().y >= 0.0 && geometry.getCoordinate().y <= 4.0 ? 1 : 0) != 0);
    }

    public void testProjectionListener() {
        PListener listener = new PListener();
        this.geography.addProjectionListener(listener);
        this.town.remove((Object)this.cars[0]);
        GeographyTest.assertEquals((Object)this.cars[0], (Object)listener.removedObj);
        Car car = new Car("foo", "bar", 199, "blue");
        this.town.add((Object)car);
        GeographyTest.assertEquals((Object)car, (Object)listener.addedObj);
        Coordinate coord = new Coordinate(-87.2, 42.1);
        Point geom = new GeometryFactory().createPoint(coord);
        this.geography.move(car, (Geometry)geom);
        GeographyTest.assertEquals((Object)car, (Object)listener.movedObj);
        GeographyTest.assertEquals(this.geography, (Object)listener.proj);
    }

    class PListener
    implements ProjectionListener {
        Object movedObj;
        Object addedObj;
        Object removedObj;
        Projection proj;

        PListener() {
        }

        public void projectionEventOccurred(ProjectionEvent evt) {
            this.proj = evt.getProjection();
            ProjectionEvent.Type type = evt.getType();
            if (type == ProjectionEvent.Type.OBJECT_MOVED) {
                this.movedObj = evt.getSubject();
            } else if (type == ProjectionEvent.OBJECT_REMOVED) {
                this.removedObj = evt.getSubject();
            } else if (type == ProjectionEvent.OBJECT_ADDED) {
                this.addedObj = evt.getSubject();
            }
        }
    }
}

