/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import repast.simphony.space.gis.DefaultFeatureAgentFactory;
import repast.simphony.space.gis.FeatureAttributeAdapter;
import repast.simphony.space.gis.ShapefileFeatureAgentFactory;

public class FeatureAgentFactoryFinder {
    private static FeatureAgentFactoryFinder instance = new FeatureAgentFactoryFinder();
    private Map<Class<?>, List<FeatureAttributeAdapter>> adapterMap = new HashMap();

    public static FeatureAgentFactoryFinder getInstance() {
        return instance;
    }

    public void clearAdapters() {
        this.adapterMap.clear();
    }

    private FeatureAgentFactoryFinder() {
    }

    public void addAdapter(Class<?> adapteeClass, FeatureAttributeAdapter adapter) {
        List<FeatureAttributeAdapter> list = this.adapterMap.get(adapteeClass);
        if (list == null) {
            list = new ArrayList<FeatureAttributeAdapter>();
            this.adapterMap.put(adapteeClass, list);
        }
        if (!this.containsAdapterFor(list, adapter.getAttributeName())) {
            list.add(adapter);
        }
    }

    private boolean containsAdapterFor(List<FeatureAttributeAdapter> list, String featureName) {
        for (FeatureAttributeAdapter adapter : list) {
            if (!adapter.getAttributeName().equals(featureName)) continue;
            return true;
        }
        return false;
    }

    public DefaultFeatureAgentFactory getFeatureAgentFactory(Class<?> agentType, Class<? extends Geometry> geometryType, CoordinateReferenceSystem crs) {
        List<FeatureAttributeAdapter> list = this.adapterMap.get(agentType);
        if (list == null) {
            list = new ArrayList<FeatureAttributeAdapter>();
        }
        return new DefaultFeatureAgentFactory(agentType, geometryType, crs, list);
    }

    public ShapefileFeatureAgentFactory getShapefileFeatureAgentFactory(Class<?> agentType, Class<? extends Geometry> geometryType, CoordinateReferenceSystem crs) {
        List<FeatureAttributeAdapter> list = this.adapterMap.get(agentType);
        if (list == null) {
            list = new ArrayList<FeatureAttributeAdapter>();
        } else {
            Iterator<FeatureAttributeAdapter> iter = list.iterator();
            while (iter.hasNext()) {
                FeatureAttributeAdapter adapter = iter.next();
                if (!adapter.getAttributeName().equals("__sele_cted__")) continue;
                iter.remove();
            }
        }
        return new ShapefileFeatureAgentFactory(agentType, geometryType, crs, list);
    }
}

