/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import repast.simphony.space.gis.FeatureAgent;
import repast.simphony.space.gis.FeatureAttributeAdapter;
import repast.simphony.space.gis.Geography;
import simphony.util.messages.MessageCenter;

public abstract class FeatureAgentFactory<T> {
    public static final String GEOM_ATTRIBUTE_NAME = "the_geom";
    MessageCenter msg = MessageCenter.getMessageCenter(this.getClass());
    private Map<Class, SimpleFeatureType> types = new HashMap<Class, SimpleFeatureType>();
    private Map<Class, Class> primitiveMap = new HashMap<Class, Class>();
    private Set<Class> legalShapefileAttribs = new HashSet<Class>();
    protected List<ObjectClassAttributeData> classAttributeList;

    public abstract FeatureAgent getFeature(T var1, Geography var2);

    public FeatureAgentFactory() {
        this.primitiveMap.put(Double.TYPE, Double.class);
        this.primitiveMap.put(Integer.TYPE, Integer.class);
        this.primitiveMap.put(Float.TYPE, Float.class);
        this.primitiveMap.put(Long.TYPE, Long.class);
        this.primitiveMap.put(Short.TYPE, Short.class);
        this.primitiveMap.put(Byte.TYPE, Byte.class);
        this.primitiveMap.put(Boolean.TYPE, Boolean.class);
        this.legalShapefileAttribs = new HashSet<Class>();
        this.legalShapefileAttribs.addAll(this.primitiveMap.keySet());
        this.legalShapefileAttribs.addAll(this.primitiveMap.values());
        this.legalShapefileAttribs.add(String.class);
    }

    protected SimpleFeatureType getShapefileFeatureType(Class agentClass, CoordinateReferenceSystem coordRefSystem, Class<? extends Geometry> geomClass) throws IntrospectionException, SchemaException {
        return this.getShapefileFeatureType(agentClass, coordRefSystem, geomClass, new ArrayList<FeatureAttributeAdapter>());
    }

    private boolean containsTypeName(List<AttributeType> types, String name) {
        for (AttributeType type : types) {
            if (!type.getName().equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    protected SimpleFeatureType getShapefileFeatureType(Class agentClass, CoordinateReferenceSystem coordRefSystem, Class<? extends Geometry> geomClass, List<FeatureAttributeAdapter> adapters) throws IntrospectionException, SchemaException {
        BeanInfo info = Introspector.getBeanInfo(agentClass, Object.class);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        ArrayList<AttributeDescriptor> ats = new ArrayList<AttributeDescriptor>();
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        int i = 0;
        while (i < pds.length) {
            String fieldName = pds[i].getName();
            Method method = pds[i].getReadMethod();
            if (method != null) {
                Class<?> returnType = method.getReturnType();
                Class<?> retType = this.primitiveMap.get(returnType);
                if (retType == null) {
                    retType = returnType;
                }
                if (this.legalShapefileAttribs.contains(retType)) {
                    builder.setBinding(retType);
                    builder.setNillable(true);
                    ats.add(builder.buildDescriptor(fieldName));
                }
            }
            ++i;
        }
        for (FeatureAttributeAdapter adapter : adapters) {
            Class<?> returnType = adapter.getAttributeType();
            Class<?> retType = this.primitiveMap.get(returnType);
            if (retType == null) {
                retType = returnType;
            }
            if (!this.legalShapefileAttribs.contains(retType)) continue;
            builder.setBinding(retType);
            builder.setNillable(true);
            ats.add(builder.buildDescriptor(adapter.getAttributeName()));
        }
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        String featureTypeName = String.valueOf(agentClass.getName()) + ".FeatureType";
        ftBuilder.setName(featureTypeName);
        ftBuilder.setCRS(coordRefSystem);
        ftBuilder.add(GEOM_ATTRIBUTE_NAME, geomClass);
        for (AttributeDescriptor ad : ats) {
            ftBuilder.add(ad);
        }
        return ftBuilder.buildFeatureType();
    }

    protected SimpleFeatureType getFeatureType(Class agentClass, CoordinateReferenceSystem coordRefSystem, Class<? extends Geometry> geomClass) throws IntrospectionException, SchemaException {
        return this.getFeatureType(agentClass, coordRefSystem, geomClass, new ArrayList<FeatureAttributeAdapter>());
    }

    protected SimpleFeatureType getFeatureType(Class agentClass, CoordinateReferenceSystem coordRefSystem, Class<? extends Geometry> geomClass, List<FeatureAttributeAdapter> adapters) throws IntrospectionException, SchemaException {
        SimpleFeatureType type = this.types.get(agentClass);
        if (type != null) {
            return type;
        }
        BeanInfo info = Introspector.getBeanInfo(agentClass, Object.class);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        ArrayList<AttributeDescriptor> ats = new ArrayList<AttributeDescriptor>();
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        int i = 0;
        while (i < pds.length) {
            String fieldName = pds[i].getName();
            Method method = pds[i].getReadMethod();
            if (method != null) {
                Class<?> returnType = method.getReturnType();
                Class<?> retType = this.primitiveMap.get(returnType);
                if (retType == null) {
                    retType = returnType;
                }
                builder.setBinding(retType);
                builder.setNillable(true);
                ats.add(builder.buildDescriptor(fieldName));
            }
            ++i;
        }
        for (FeatureAttributeAdapter adapter : adapters) {
            Class<?> returnType = adapter.getAttributeType();
            Class<?> retType = this.primitiveMap.get(returnType);
            if (retType == null) {
                retType = returnType;
            }
            builder.setBinding(retType);
            builder.setNillable(true);
            ats.add(builder.buildDescriptor(adapter.getAttributeName()));
        }
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        String featureTypeName = String.valueOf(agentClass.getName()) + ".FeatureType";
        ftBuilder.setName(featureTypeName);
        ftBuilder.setCRS(coordRefSystem);
        ftBuilder.add(GEOM_ATTRIBUTE_NAME, geomClass);
        for (AttributeDescriptor ad : ats) {
            ftBuilder.add(ad);
        }
        type = ftBuilder.buildFeatureType();
        this.types.put(agentClass, type);
        return type;
    }

    protected void createClassAttributes(Class<T> agentClass) {
        this.classAttributeList = new ArrayList<ObjectClassAttributeData>();
        try {
            BeanInfo info = Introspector.getBeanInfo(agentClass, Object.class);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            FastClass fastClass = FastClass.create(agentClass);
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                String featureName = pd.getName();
                if (pd.getReadMethod() != null) {
                    FastMethod readMethod = fastClass.getMethod(pd.getReadMethod());
                    FastMethod writeMethod = pd.getWriteMethod() == null ? null : fastClass.getMethod(pd.getWriteMethod());
                    this.classAttributeList.add(new ObjectClassAttributeData(featureName, readMethod, writeMethod));
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            this.msg.error((Object)"Unable to create feature attributes from agent", (Throwable)e, new Object[0]);
        }
    }

    static class ObjectClassAttributeData {
        private String name;
        private FastMethod readMethod;
        private FastMethod writeMethod;

        public ObjectClassAttributeData(String name, FastMethod readMethod, FastMethod writeMethod) {
            this.name = name;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        public String getName() {
            return this.name;
        }

        public FastMethod getReadMethod() {
            return this.readMethod;
        }

        public FastMethod getWriteMethod() {
            return this.writeMethod;
        }
    }
}

