/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.InvocationTargetException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastMethod;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import repast.simphony.space.gis.FeatureAgentFactory;
import repast.simphony.space.gis.FeatureAttributeAdapter;
import repast.simphony.space.gis.Geography;
import simphony.util.messages.MessageCenter;

public class FeatureAgent<T>
implements SimpleFeature {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(FeatureAgent.class);
    protected FeatureId id = new FeatureIdImpl("fid-" + new UID().toString().replace(':', '_'));
    protected SimpleFeatureType featureType;
    private T agentObj;
    private Map<String, FeatureAttributeAdapter> attributeMap;
    protected String geometryName;
    private Geometry geom;
    private Geography geography;
    private Map<Object, Object> userData;

    public FeatureAgent(SimpleFeatureType type, T agent, Geography geog, List<FeatureAttributeAdapter> adapters, List<FeatureAgentFactory.ObjectClassAttributeData> classAttributeList) {
        this.featureType = type;
        this.agentObj = agent;
        this.geography = geog;
        if (this.geography != null) {
            this.geom = this.geography.getGeometry(agent);
        }
        this.geometryName = "the_geom";
        this.userData = new HashMap<Object, Object>();
        this.createAttributes(adapters, classAttributeList);
    }

    private void createAttributes(List<FeatureAttributeAdapter> adapters, List<FeatureAgentFactory.ObjectClassAttributeData> classAttributeList) {
        this.attributeMap = new HashMap<String, FeatureAttributeAdapter>();
        for (FeatureAgentFactory.ObjectClassAttributeData attrData : classAttributeList) {
            this.attributeMap.put(attrData.getName(), new ObjectFeatureAgentAttribute(attrData));
        }
        for (FeatureAttributeAdapter adapter : adapters) {
            this.attributeMap.put(adapter.getAttributeName(), adapter);
        }
    }

    public T getAgent() {
        return this.agentObj;
    }

    private String getAttributeName(int i) {
        String name = null;
        AttributeType type = this.featureType.getType(i);
        if (type != null) {
            name = type.getName().getLocalPart();
        }
        return name;
    }

    public String getID() {
        return this.id.getID();
    }

    public SimpleFeatureType getType() {
        return this.getFeatureType();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureId getIdentifier() {
        return this.id;
    }

    public List<Object> getAttributes() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(0, this.getDefaultGeometry());
        int i = 1;
        int n = this.featureType.getAttributeCount();
        while (i < n) {
            String name = this.getAttributeName(i);
            FeatureAttributeAdapter attribute = this.attributeMap.get(name);
            objects.add(attribute.getAttribute(this.agentObj));
            ++i;
        }
        return objects;
    }

    public Object getAttribute(String name) {
        FeatureAttributeAdapter getter;
        Object obj = null;
        if (name.equals(this.geometryName)) {
            obj = this.getDefaultGeometry();
        }
        if ((getter = this.attributeMap.get(name)) != null) {
            obj = getter.getAttribute(this.agentObj);
        }
        return obj;
    }

    public void setAttribute(String name, Object obj) {
        if (obj instanceof Geometry) {
            this.geometryName = name;
            this.setDefaultGeometry((Geometry)obj);
            return;
        }
        FeatureAttributeAdapter setter = this.attributeMap.get(name);
        if (setter != null) {
            setter.setAttribute(this.agentObj, obj);
        }
    }

    public Object getAttribute(Name name) {
        return this.getAttribute(name.getLocalPart());
    }

    public void setAttribute(Name name, Object value) {
        this.setAttribute(name.getLocalPart(), value);
    }

    public Object getAttribute(int index) {
        FeatureAttributeAdapter getter;
        Object obj = null;
        String name = this.getAttributeName(index);
        if (index == 0) {
            obj = this.getDefaultGeometry();
        }
        if (name != null && (getter = this.attributeMap.get(name)) != null) {
            obj = getter.getAttribute(this.agentObj);
        }
        return obj;
    }

    public void setAttribute(int index, Object val) throws IndexOutOfBoundsException {
        String name = this.getAttributeName(index);
        if (index == 0) {
            this.setDefaultGeometry((Geometry)val);
            return;
        }
        FeatureAttributeAdapter setter = this.attributeMap.get(name);
        if (setter == null) {
            throw new IndexOutOfBoundsException("Unable to set attribute '" + name + "', attribute not found");
        }
        setter.setAttribute(this.agentObj, val);
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public Geometry getDefaultGeometry() {
        Geometry tmp = this.geography.getGeometry(this.agentObj);
        if (tmp == null) {
            return (Geometry)this.geom.clone();
        }
        this.geom = tmp;
        return (Geometry)this.geom.clone();
    }

    public void setDefaultGeometry(Object geometry) {
        this.geom = (Geometry)geometry;
        if (this.geography != null) {
            this.geography.move(this.agentObj, (Geometry)geometry);
        }
    }

    public BoundingBox getBounds() {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.featureType.getCoordinateReferenceSystem());
        if (bounds.isNull()) {
            bounds.init(this.geom.getEnvelopeInternal());
        } else {
            bounds.expandToInclude(this.geom.getEnvelopeInternal());
        }
        return bounds;
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
        GeometryAttributeImpl geometryAttribute = null;
        if (geometryDescriptor != null) {
            Geometry defaultGeometry = this.getDefaultGeometry();
            geometryAttribute = new GeometryAttributeImpl((Object)defaultGeometry, geometryDescriptor, null);
        }
        return geometryAttribute;
    }

    public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        if (geometryAttribute != null) {
            this.setDefaultGeometry(geometryAttribute.getValue());
        } else {
            this.setDefaultGeometry(null);
        }
    }

    public boolean isNillable() {
        return true;
    }

    public Name getName() {
        return this.featureType.getName();
    }

    public AttributeDescriptor getDescriptor() {
        return new AttributeDescriptorImpl((AttributeType)this.featureType, this.featureType.getName(), 0, Integer.MAX_VALUE, true, null);
    }

    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public Collection<Property> getProperties() {
        return null;
    }

    public Collection<Property> getProperties(Name arg0) {
        return null;
    }

    public Collection<Property> getProperties(String arg0) {
        return null;
    }

    public Property getProperty(Name arg0) {
        return null;
    }

    public Property getProperty(String arg0) {
        return null;
    }

    public Collection<? extends Property> getValue() {
        return null;
    }

    public void setValue(Collection<Property> arg0) {
    }

    public void validate() throws IllegalAttributeException {
    }

    public void setValue(Object arg0) {
    }

    public void setAttributes(List<Object> arg0) {
    }

    public void setAttributes(Object[] arg0) {
    }

    static class ObjectFeatureAgentAttribute
    implements FeatureAttributeAdapter {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private String name;
        private FastMethod readMethod;
        private FastMethod writeMethod;

        public ObjectFeatureAgentAttribute(FeatureAgentFactory.ObjectClassAttributeData data) {
            this.name = data.getName();
            this.readMethod = data.getReadMethod();
            this.writeMethod = data.getWriteMethod();
        }

        public ObjectFeatureAgentAttribute(String name, FastMethod readMethod, FastMethod writeMethod) {
            this.name = name;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
        }

        @Override
        public String getAttributeName() {
            return this.name;
        }

        public Object getAttribute(Object adaptee) {
            try {
                return this.readMethod.invoke(adaptee, EMPTY_ARRAY);
            }
            catch (InvocationTargetException e) {
                MessageCenter.getMessageCenter(this.getClass()).error((Object)"Unable to get feature attribute from object", (Throwable)e, new Object[0]);
                return null;
            }
        }

        public void setAttribute(Object adaptee, Object value) {
            try {
                this.writeMethod.invoke(adaptee, new Object[]{value});
            }
            catch (InvocationTargetException e) {
                msgCenter.error((Object)"Unable to set attribute: ", (Throwable)e, new Object[0]);
            }
        }

        @Override
        public Class<?> getAttributeType() {
            return this.readMethod.getReturnType();
        }
    }
}

