/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.beans.IntrospectionException;
import java.util.List;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import repast.simphony.space.gis.FeatureAgent;
import repast.simphony.space.gis.FeatureAgentFactory;
import repast.simphony.space.gis.FeatureAttributeAdapter;
import repast.simphony.space.gis.Geography;
import simphony.util.messages.MessageCenter;

public class DefaultFeatureAgentFactory<T>
extends FeatureAgentFactory<T> {
    MessageCenter msg = MessageCenter.getMessageCenter(this.getClass());
    private CoordinateReferenceSystem crs = DefaultGeographicCRS.WGS84;
    private Class<? extends Geometry> geometryType = Point.class;
    private SimpleFeatureType featureType;
    private List<FeatureAttributeAdapter> adapters;

    DefaultFeatureAgentFactory(Class<T> agentType, Class<? extends Geometry> geometryType, CoordinateReferenceSystem crs, List<FeatureAttributeAdapter> adapters) {
        this.geometryType = geometryType;
        this.crs = crs;
        this.adapters = adapters;
        this.init(agentType);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    private void init(Class<T> agentType) {
        try {
            this.featureType = this.getFeatureType(agentType, this.crs, this.geometryType, this.adapters);
        }
        catch (IntrospectionException e) {
            this.msg.error((Object)("Unable to introspect feature class: " + agentType.getName()), (Throwable)e, new Object[0]);
        }
        catch (SchemaException e) {
            this.msg.error((Object)"Error creating FeatureType", (Throwable)e, new Object[0]);
        }
        this.createClassAttributes(agentType);
    }

    @Override
    public FeatureAgent getFeature(T agent, Geography geography) {
        FeatureAgent<T> featureAgent = new FeatureAgent<T>(this.featureType, agent, geography, this.adapters, this.classAttributeList);
        return featureAgent;
    }
}

