/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.collections15.Predicate;
import repast.simphony.query.space.gis.AbstractGeometryQuery;
import repast.simphony.space.gis.Geography;

public class TouchesQuery<T>
extends AbstractGeometryQuery<T> {
    public TouchesQuery(Geography<T> geography, T sourceObject) {
        super(geography, sourceObject);
    }

    public TouchesQuery(Geography<T> geography, Geometry geom) {
        super(geography, geom);
    }

    @Override
    protected Predicate<T> createPredicate() {
        return new TouchesPredicate(this.geom, this.geography);
    }

    static class TouchesPredicate<T>
    implements Predicate<T> {
        private Geometry geom;
        private Geography geo;

        TouchesPredicate(Geometry geom, Geography geo) {
            this.geom = geom;
            this.geo = geo;
        }

        public boolean evaluate(T o) {
            Geometry other = this.geo.getGeometry(o);
            return other != null && !other.equals(this.geom) && this.geom.touches(other);
        }
    }
}

