/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.collections15.Predicate;
import repast.simphony.query.space.gis.AbstractGeometryQuery;
import repast.simphony.space.gis.Geography;

public class ContainsQuery<T>
extends AbstractGeometryQuery<T> {
    public ContainsQuery(Geography<T> geography, T sourceObject) {
        super(geography, sourceObject);
    }

    public ContainsQuery(Geography<T> geography, Geometry geom) {
        super(geography, geom);
    }

    @Override
    protected Predicate<T> createPredicate() {
        if (this.sourceObject == null) {
            return new NoSourceContainsPredicate();
        }
        return new ContainsPredicate();
    }

    private class ContainsPredicate<T>
    implements Predicate<T> {
        private ContainsPredicate() {
        }

        public boolean evaluate(T o) {
            if (!ContainsQuery.this.sourceObject.equals(o)) {
                Geometry other = ContainsQuery.this.geography.getGeometry(o);
                return other != null && ContainsQuery.this.geom.contains(other);
            }
            return false;
        }
    }

    private class NoSourceContainsPredicate<T>
    implements Predicate<T> {
        private NoSourceContainsPredicate() {
        }

        public boolean evaluate(T o) {
            Geometry other = ContainsQuery.this.geography.getGeometry(o);
            return other != null && ContainsQuery.this.geom.contains(other);
        }
    }
}

