/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.collections15.Predicate;
import repast.simphony.query.Query;
import repast.simphony.query.QueryUtils;
import repast.simphony.space.gis.Geography;
import repast.simphony.util.collections.FilteredIterator;
import simphony.util.messages.MessageCenter;

public abstract class AbstractGeometryQuery<T>
implements Query<T> {
    protected Geography<T> geography;
    protected Geometry geom;
    protected Predicate<T> predicate;
    protected T sourceObject;
    private static final MessageCenter msg = MessageCenter.getMessageCenter(AbstractGeometryQuery.class);

    public AbstractGeometryQuery(Geography<T> geography, T sourceObject) {
        this(geography, geography.getGeometry(sourceObject));
        this.sourceObject = sourceObject;
        this.predicate = this.createPredicate();
    }

    public AbstractGeometryQuery(Geography<T> geography, Geometry geom) {
        if (geom == null) {
            msg.error((Object)"Error creating geography query", (Throwable)new IllegalArgumentException("Null geometry argument."), new Object[0]);
        }
        this.geography = geography;
        this.geom = geom;
        this.predicate = this.createPredicate();
    }

    protected abstract Predicate<T> createPredicate();

    public Iterable<T> query(Iterable<T> set) {
        return new FilteredIterator(this.query().iterator(), (Predicate)QueryUtils.createContains(set));
    }

    public Iterable<T> query() {
        if (this.geom == null) {
            return null;
        }
        Envelope envelope = this.geom.getEnvelopeInternal();
        Iterable<T> potential = this.geography.queryInexact(envelope);
        return new FilteredIterator(potential.iterator(), this.predicate);
    }
}

