/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;

public class GeometryUtil {
    public static GeometryType findGeometryType(Class geomClass) {
        if (Point.class.equals((Object)geomClass) || MultiPoint.class.equals((Object)geomClass)) {
            return GeometryType.POINT;
        }
        if (Polygon.class.equals((Object)geomClass) || MultiPolygon.class.equals((Object)geomClass)) {
            return GeometryType.POLYGON;
        }
        if (LineString.class.equals((Object)geomClass) || MultiLineString.class.equals((Object)geomClass)) {
            return GeometryType.LINE;
        }
        return GeometryType.OTHER;
    }

    public static GeometryType findGeometryType(Geometry geom) {
        if (geom instanceof Point || geom instanceof MultiPoint) {
            return GeometryType.POINT;
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            return GeometryType.POLYGON;
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            return GeometryType.LINE;
        }
        return GeometryType.OTHER;
    }

    public static GeometryType findGeometryType(Style style) {
        if (SLD.pointSymbolizer((Style)style) != null) {
            return GeometryType.POINT;
        }
        if (SLD.lineSymbolizer((Style)style) != null) {
            return GeometryType.LINE;
        }
        if (SLD.polySymbolizer((Style)style) != null) {
            return GeometryType.POLYGON;
        }
        return GeometryType.OTHER;
    }

    public static GeometryType findGeometryType(SimpleFeature feature) {
        Object geom = feature.getDefaultGeometry();
        if (geom instanceof Point || geom instanceof MultiPoint) {
            return GeometryType.POINT;
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            return GeometryType.POLYGON;
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            return GeometryType.LINE;
        }
        return GeometryType.OTHER;
    }

    public static enum GeometryType {
        POINT,
        LINE,
        POLYGON,
        OTHER;

    }
}

