/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.jscience.physics.amount.Amount;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.ShapefileWriter;

public class WriterTest {
    private Geography geog;

    @Before
    public void setUp() {
        DefaultContext context = new DefaultContext();
        GeographyParameters geoParams = new GeographyParameters();
        this.geog = GeographyFactoryFinder.createGeographyFactory(null).createGeography("Geography", context, geoParams);
        GeometryFactory fac = new GeometryFactory();
        int i = 0;
        while (i < 10) {
            GisAgent agent = new GisAgent();
            context.add((Object)agent);
            agent.setWealth(i);
            Coordinate coord = new Coordinate(-103.823 + (double)i / 100.0, 44.373 + (double)i / 100.0);
            Point geom = fac.createPoint(coord);
            this.geog.move(agent, (Geometry)geom);
            ++i;
        }
    }

    @Test
    public void writeTest() throws IOException {
        File file = new File("test/testWrite.shp");
        ShapefileWriter writer = new ShapefileWriter(this.geog);
        writer.write(this.geog.getLayer(GisAgent.class).getName(), file.toURI().toURL());
        HashSet<String> set = new HashSet<String>();
        for (Object obj : this.geog.getLayer(GisAgent.class).getAgentSet()) {
            set.add(this.geog.getGeometry(obj).toText());
        }
        ShapefileDataStore store = new ShapefileDataStore(file.toURL());
        ContentFeatureCollection collection = store.getFeatureSource().getFeatures();
        Assert.assertEquals((long)10L, (long)collection.size());
        SimpleFeatureIterator iter = collection.features();
        while (iter.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iter.next();
            Assert.assertTrue((boolean)set.remove(feature.getDefaultGeometry().toString()));
        }
        Assert.assertEquals((long)0L, (long)set.size());
    }

    static class GisAgent {
        private double wealth = 10.0;
        private long longVal = 3L;
        private float floatVal = 3.3f;
        private String strVal = "hello";
        private int intVal = 3;
        private Amount amount = Amount.valueOf((long)10L, (Unit)SI.METER);

        public Amount getAmount() {
            return this.amount;
        }

        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        public double getWealth() {
            return this.wealth;
        }

        public void setWealth(double wealth) {
            this.wealth = wealth;
        }

        public long getLongVal() {
            return this.longVal;
        }

        public float getFloatVal() {
            return this.floatVal;
        }

        public String getStrVal() {
            return this.strVal;
        }

        public int getIntVal() {
            return this.intVal;
        }
    }
}

