/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.dataLoader;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.dataLoader.engine.ContextXMLBuilder;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.gis.engine.GeographyProjectionController;
import repast.simphony.parameter.ParameterFormatException;
import repast.simphony.parameter.ParameterType;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.scenario.data.Attribute;
import repast.simphony.scenario.data.AttributeFactory;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.ContextFileReader;
import repast.simphony.scenario.data.ProjectionData;
import repast.simphony.space.gis.Geography;

public class AutoBuilderTest {
    private ContextData sContext;
    private Context context;
    private Parameters params;

    @Before
    public void init() throws IOException, ParameterFormatException, XMLStreamException {
        new GeographyProjectionController();
        this.sContext = new ContextFileReader().read(new File("./test/repast/simphony/gis/dataLoader/context.xml"), new Classpath());
        this.context = new DefaultContext();
        ParametersCreator creator = new ParametersCreator();
        for (ProjectionData proj : this.sContext.projections()) {
            for (Attribute attribute : proj.attributes()) {
                ParameterType type = AttributeFactory.toParameterType((Attribute)attribute);
                creator.addParameter(String.valueOf(proj.getId()) + attribute.getId(), attribute.getDisplayName(), type.getJavaClass(), type.getValue(attribute.getValue()), false);
            }
        }
        this.params = creator.createParameters();
        RunEnvironment.init(null, null, (Parameters)this.params, (boolean)false);
    }

    @Test
    public void geogCreation() {
        ContextXMLBuilder builder = new ContextXMLBuilder(this.sContext);
        builder.build(this.context);
        Geography geog = (Geography)this.context.getProjection("Geography");
        Assert.assertTrue((geog != null ? 1 : 0) != 0);
    }
}

