/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzipper {
    public void run(String zipFile) throws IOException {
        try (ZipFile zip = null;){
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                File file = new File(".", entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                ReadableByteChannel source = Channels.newChannel(zip.getInputStream(entry));
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileChannel dstChannel = new FileOutputStream(file).getChannel();
                dstChannel.transferFrom(source, 0L, entry.getSize());
                dstChannel.close();
                source.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Unzipper().run(args[0]);
    }
}

