/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSession;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.StatusException;

public class RemoteStatusGetter {
    public void run(RemoteSession remote, String remoteDir) throws StatusException {
        SSHSession session = null;
        File file = null;
        try {
            try {
                Path tmp = Files.createTempDirectory(null, new FileAttribute[0]);
                session = SSHSessionFactory.getInstance().create(remote);
                file = session.copyFileFromRemote(tmp.toFile().getPath().replace("\\", "/"), new File(String.valueOf(remoteDir) + "/" + "status_output.properties"), false);
                Properties props = new Properties();
                props.load(new FileReader(file));
                for (String key : props.stringPropertyNames()) {
                    remote.setRunStatus(Integer.valueOf(key), RunningStatus.valueOf(props.getProperty(key)));
                }
            }
            catch (SftpException e) {
                e.printStackTrace();
                String msg = String.format("Error while copying status output file from %s", remote.getId());
                throw new StatusException(msg, e);
            }
            catch (JSchException e) {
                String msg = String.format("Error while creating connection to %s", remote.getId());
                throw new StatusException(msg, e);
            }
            catch (IOException e) {
                String msg = String.format("Error reading status file '%s' from remote %s", file.getPath(), remote.getId());
                throw new StatusException(msg, e);
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

