/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSession;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.StatusException;
import repast.simphony.util.FileUtils;

public class RemoteStatusCopier {
    public void run(RemoteSession remote, String remoteDir, String outDir) throws StatusException {
        SSHSession session = null;
        try {
            try {
                session = SSHSessionFactory.getInstance().create(remote);
                ArrayList<File> filesToCopy = new ArrayList<File>();
                int i = 1;
                while (i <= remote.getInstances()) {
                    RunningStatus status = remote.getStatus(i);
                    if (status != RunningStatus.OK) {
                        String dir = new File(remoteDir, "instance_" + i).getPath().replace("\\", "/");
                        List<String> ls = session.listRemoteDirectory(dir);
                        for (String fname : ls) {
                            File f = new File(fname);
                            if (!f.getName().startsWith(RunningStatus.FAILURE.toString()) && !f.getName().startsWith(RunningStatus.WARN.toString())) continue;
                            filesToCopy.add(f);
                        }
                    }
                    ++i;
                }
                Path tmp = Files.createTempDirectory(null, new FileAttribute[0]);
                List<File> copiedFiles = session.copyFilesFromRemote(tmp.toFile().getPath(), filesToCopy, false);
                String prefix = String.valueOf(remote.getUser()) + "_" + remote.getHost();
                for (File file : copiedFiles) {
                    String fname = file.getName();
                    String status = fname.contains(RunningStatus.FAILURE.toString()) ? "_failure" : "_warn";
                    int instance = Integer.parseInt(fname.substring(fname.indexOf("_") + 1, fname.length()));
                    File newFile = new File(outDir, String.valueOf(prefix) + "_" + instance + status + ".txt");
                    FileUtils.copyFile((File)file, (File)newFile);
                }
            }
            catch (SftpException e) {
                String msg = String.format("Error while copying instance status files from %s", remote.getId());
                throw new StatusException(msg, e);
            }
            catch (JSchException e) {
                String msg = String.format("Error while creating connection to %s", remote.getId());
                throw new StatusException(msg, e);
            }
            catch (IOException e) {
                String msg = String.format("Error copying status files from temporary directory to %s", outDir);
                throw new StatusException(msg, e);
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

