/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.ModelArchiveConfigurator;
import repast.simphony.batch.ssh.ModelArchiveConfiguratorException;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.RemoteDonePoller;
import repast.simphony.batch.ssh.RemoteOutputFinderCopier;
import repast.simphony.batch.ssh.RemoteStatusCopier;
import repast.simphony.batch.ssh.RemoteStatusGetter;
import repast.simphony.batch.ssh.SSHSession;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.SessionException;
import repast.simphony.batch.ssh.StatusException;

public class RemoteSession
implements Session {
    private static Logger logger = Logger.getLogger(RemoteSession.class);
    String host;
    String user;
    String input = "";
    String keyFile = "id_rsa";
    int instances = 0;
    private File modelArchive = null;
    private String remoteDirectory = null;
    private Map<Integer, RunningStatus> stati = new HashMap<Integer, RunningStatus>();

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public String getId() {
        return String.valueOf(this.user) + "@" + this.host;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    @Override
    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public void setRunStatus(int instance, RunningStatus status) {
        this.stati.put(instance, status);
    }

    @Override
    public RunningStatus getStatus(int instance) {
        return this.stati.get(instance);
    }

    @Override
    public void initModelArchive(Configuration config, String directory) throws ModelArchiveConfiguratorException, SessionException {
        this.remoteDirectory = directory;
        ModelArchiveConfigurator archConfig = new ModelArchiveConfigurator();
        this.modelArchive = archConfig.configure(this, config);
        logger.info((Object)String.format("%n\tCopying %s to %n\t%s@%s:~/%s/%s ...", this.modelArchive.getAbsolutePath(), this.getUser(), this.getHost(), directory, this.modelArchive.getName()));
        this.copyFile(this.modelArchive, directory);
        logger.info((Object)"Copying Finished.");
    }

    private void copyFile(File file, String remoteDir) throws SessionException {
        SSHSession session = null;
        try {
            try {
                session = SSHSessionFactory.getInstance().create(this);
                String cmd = String.format("mkdir %s", remoteDir);
                int exitStatus = session.executeCmd(cmd, Level.ERROR);
                if (exitStatus != 0) {
                    String msg = String.format("Error executing '%s' on remote %s. See log for details.", cmd, this.getId());
                    throw new SessionException(msg);
                }
                session.copyFileToRemote(file, remoteDir);
            }
            catch (JSchException e) {
                String msg = String.format("Error while creating connection to %s", this.getId());
                throw new SessionException(msg, e);
            }
            catch (SftpException e) {
                String msg = String.format("Error while copying %s via sftp to %s", file.getPath(), this.getId());
                throw new SessionException(msg, e);
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private void unzipModel(SSHSession session) throws JSchException, SessionException {
        logger.info((Object)String.format("Unzipping model on %s@%s", this.getUser(), this.getHost()));
        String cmd = String.format("cd %s; java -jar %s %s", this.remoteDirectory, this.modelArchive.getName(), this.modelArchive.getName());
        int exitStatus = session.executeCmd(cmd, Level.ERROR);
        if (exitStatus != 0) {
            String msg = String.format("Error executing '%s' on remote %s. See log for details.", cmd, this.getId());
            throw new SessionException(msg);
        }
    }

    private void checkForJava(SSHSession session) throws JSchException, SessionException {
        logger.info((Object)String.format("Checking for java on %s@%s", this.getUser(), this.getHost()));
        int exitStatus = session.executeCmd("java -version", Level.INFO);
        if (exitStatus != 0) {
            String msg = String.format("Error executing java on remote %s. Is it installed?", this.getId());
            throw new SessionException(msg);
        }
    }

    private boolean checkIfRunning(SSHSession session, String javaCmd, boolean isRemoteWindows) throws JSchException, IOException, SessionException {
        StringBuilder builder = new StringBuilder();
        if (isRemoteWindows) {
            session.executeCmd("ps -W", builder, true);
        } else {
            session.executeCmd("ps x", builder, true);
        }
        String psOutput = builder.toString();
        if (isRemoteWindows) {
            return psOutput.contains("java.exe");
        }
        return psOutput.contains(javaCmd.replace("\"", ""));
    }

    @Override
    public void runModel() throws SessionException {
        if (this.modelArchive == null) {
            throw new SessionException("Model has not been initialized for running. Call initModel first.");
        }
        SSHSession session = null;
        try {
            try {
                session = SSHSessionFactory.getInstance().create(this);
                this.checkForJava(session);
                this.unzipModel(session);
                boolean isRemoteWindows = false;
                try {
                    StringBuilder builder = new StringBuilder();
                    int exitStatus = session.executeCmd("nohup ls > /dev/null", builder, false);
                    isRemoteWindows = exitStatus != 0;
                }
                catch (IOException ex) {
                    throw new SessionException("Error checking for nohup", ex);
                }
                logger.info((Object)String.format("Running model on %s@%s ...", this.getUser(), this.getHost()));
                String javaCmd = "";
                String cmd = "";
                if (isRemoteWindows) {
                    javaCmd = String.format("java -cp \"./lib/repast.simphony.batch.jar;./lib/*\" repast.simphony.batch.LocalDriver local_batch_run.properties", this.remoteDirectory);
                    cmd = String.format("cd %s;  %s ", this.remoteDirectory, javaCmd);
                } else {
                    javaCmd = String.format("java -cp \"./lib/repast.simphony.batch.jar:./lib/*\" repast.simphony.batch.LocalDriver local_batch_run.properties", this.remoteDirectory);
                    cmd = String.format("cd %s; nohup %s ", this.remoteDirectory, javaCmd);
                }
                try {
                    session.executeBackgroundCommand(cmd);
                    boolean running = false;
                    int count = 0;
                    while (count < 40) {
                        running = this.checkIfRunning(session, javaCmd, isRemoteWindows);
                        if (running) break;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++count;
                    }
                    if (!running) {
                        String msg = String.format("Error executing '%s' on remote %s.", javaCmd, this.getId());
                        throw new SessionException(msg);
                    }
                }
                catch (JSchException e) {
                    String msg = String.format("Error executing '%s' on remote %s.", cmd, this.getId());
                    throw new SessionException(msg, e);
                }
                catch (IOException ex) {
                    String msg = String.format("Error executing ps x on remote %s when checking if model has started.", cmd, this.getId());
                    throw new SessionException(msg, ex);
                }
            }
            catch (JSchException e) {
                String msg = String.format("Error while creating connection to %s", this.getId());
                throw new SessionException(msg, e);
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
    }

    @Override
    public void retrieveRunCompletionStatus() throws StatusException {
        RemoteStatusGetter getter = new RemoteStatusGetter();
        getter.run(this, this.remoteDirectory);
    }

    @Override
    public List<MatchedFiles> findOutput(List<OutputPattern> patterns) throws StatusException {
        String tempDir = System.getProperty("java.io.tmpdir");
        RemoteOutputFinderCopier copier = new RemoteOutputFinderCopier();
        copier.addPatterns(patterns);
        File outDir = new File(tempDir, String.valueOf(this.getUser()) + "_" + this.getHost());
        outDir.mkdir();
        logger.info((Object)String.format("Finding and copying remote output from %s to %s", String.valueOf(this.getUser()) + "@" + this.getHost() + ":" + this.remoteDirectory, outDir.getPath()));
        return copier.run(this, this.remoteDirectory, outDir.getAbsolutePath());
    }

    @Override
    public void copyCompletionStatus(String outDirectory) throws StatusException {
        RemoteStatusCopier copier = new RemoteStatusCopier();
        copier.run(this, this.remoteDirectory, outDirectory);
    }

    @Override
    public Callable<Void> createDonePoller(long frequency) {
        return new RemoteDonePoller(this, this.remoteDirectory, frequency);
    }
}

