/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.OutputFinder;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSession;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.StatusException;

public class RemoteOutputFinderCopier
extends OutputFinder {
    private List<MatchedFiles> findOutputFiles(SSHSession session, List<String> instanceDirs) throws JSchException, SftpException {
        List<MatchedFiles> matchers = this.createMatches(false);
        for (String dir : instanceDirs) {
            List<String> files = session.listRemoteDirectory(dir, true);
            ArrayList<String> fixedFiles = new ArrayList<String>();
            for (String file : files) {
                fixedFiles.add(file.substring(dir.length() + 1));
            }
            this.findFiles(matchers, fixedFiles, dir);
        }
        return matchers;
    }

    public List<MatchedFiles> run(RemoteSession remote, String remoteDir, String localDir) throws StatusException {
        SSHSession session = null;
        ArrayList<MatchedFiles> localMatches = new ArrayList<MatchedFiles>();
        try {
            try {
                session = SSHSessionFactory.getInstance().create(remote);
                List<String> dirs = session.listRemoteDirectory(remoteDir);
                ArrayList<String> instances = new ArrayList<String>();
                for (String dir : dirs) {
                    if (!dir.contains("instance_")) continue;
                    instances.add(dir);
                }
                List<MatchedFiles> matches = this.findOutputFiles(session, instances);
                for (MatchedFiles match : matches) {
                    MatchedFiles newMatch = new MatchedFiles(match.getPattern());
                    for (File file : session.copyFilesFromRemote(localDir, match.getFiles(), true)) {
                        newMatch.addFile(file);
                    }
                    localMatches.add(newMatch);
                }
            }
            catch (SftpException e) {
                String msg = String.format("Error while copying output files from %s", remote.getId());
                throw new StatusException(msg, e);
            }
            catch (JSchException e) {
                String msg = String.format("Error while creating connection to %s", remote.getId());
                throw new StatusException(msg, e);
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return localMatches;
    }
}

