/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.LocalSession;
import repast.simphony.batch.ssh.StatusException;
import repast.simphony.util.FileUtils;

public class LocalStatusCopier {
    public void run(LocalSession session, File instanceParentDirectory, String outDir) throws StatusException {
        try {
            ArrayList<File> filesToCopy = new ArrayList<File>();
            int i = 1;
            while (i <= session.getInstances()) {
                RunningStatus status = session.getStatus(i);
                if (status != RunningStatus.OK) {
                    File dir = new File(instanceParentDirectory, "instance_" + i);
                    String[] stringArray = dir.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fname = stringArray[n2];
                        if (fname.startsWith(RunningStatus.FAILURE.toString()) || fname.startsWith(RunningStatus.WARN.toString())) {
                            filesToCopy.add(new File(dir, fname));
                        }
                        ++n2;
                    }
                }
                ++i;
            }
            for (File file : filesToCopy) {
                String fname = file.getName();
                String status = fname.contains(RunningStatus.FAILURE.toString()) ? "_failure" : "_warn";
                int instance = Integer.parseInt(fname.substring(fname.indexOf("_") + 1, fname.length()));
                File newFile = new File(outDir, "localhost_" + instance + status + ".txt");
                FileUtils.copyFile((File)file, (File)newFile);
            }
        }
        catch (IOException e) {
            String msg = String.format("Error copying status files to %s", outDir);
            throw new StatusException(msg, e);
        }
    }
}

