/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.text.SimpleDateFormat;
import java.util.Date;
import repast.simphony.batch.ssh.OutputPattern;

public class DefaultOutputPatternCreator {
    private String name;
    private String extension;
    private String timestamp;

    public DefaultOutputPatternCreator(String basename, boolean hasTimestamp) {
        int index = basename.lastIndexOf(".");
        if (index != -1) {
            this.name = basename.substring(0, index);
            this.extension = basename.substring(index + 1);
        } else {
            this.name = basename;
            this.extension = "";
        }
        this.timestamp = hasTimestamp ? "." + new SimpleDateFormat("yyyy.MMM.dd.HH_mm_ss").format(new Date()) : "";
    }

    private String getFinalFileName() {
        return String.valueOf(this.name) + this.timestamp + (this.extension.length() > 0 ? "." + this.extension : "");
    }

    public OutputPattern getParamMapPattern() {
        String fname = this.cleanMatchFile(this.name);
        String pattern = "{**/,}" + fname + "*" + ".batch_param_map";
        if (this.extension.length() > 0) {
            pattern = String.valueOf(pattern) + "." + this.cleanMatchFile(this.extension);
        }
        OutputPattern outPattern = new OutputPattern();
        outPattern.setPattern(pattern);
        outPattern.setPath(this.getFinalParamMapFileName());
        outPattern.setHeader(true);
        outPattern.setConcatenate(true);
        return outPattern;
    }

    public OutputPattern getFileSinkOutputPattern() {
        String fname = this.cleanMatchFile(this.name);
        String pattern = "{**/,}" + fname + "*";
        if (this.extension.length() > 0) {
            pattern = String.valueOf(pattern) + "." + this.cleanMatchFile(this.extension);
        }
        OutputPattern outPattern = new OutputPattern();
        outPattern.setPattern(pattern);
        outPattern.setPath(this.getFinalFileName());
        outPattern.setHeader(true);
        outPattern.setConcatenate(true);
        return outPattern;
    }

    private String getFinalParamMapFileName() {
        return String.valueOf(this.name) + this.timestamp + ".batch_param_map" + (this.extension.length() > 0 ? "." + this.extension : "");
    }

    private String cleanMatchFile(String filename) {
        String ret = filename.replace("*", "\\*");
        ret = ret.replace("?", "\\?");
        ret = ret.replace("{", "\\{");
        ret = ret.replace("}", "\\}");
        ret = ret.replace("\\", "\\\\");
        return ret;
    }
}

