/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.OutputPatternPropsParser;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.SessionPropsParser;

public class Configuration {
    public static final String MA_KEY = "model.archive";
    public static final String SSH_DIR_KEY = "ssh.key_dir";
    public static final String OUT_DIR_KEY = "model.output";
    public static final String BATCH_PARAMS_KEY = "batch.params.file";
    public static final String POLL_INTERVAL_KEY = "poll.frequency";
    public static final String VM_ARGS_KEY = "vm.arguments";
    public static final String LOCAL_PREFIX = "local";
    public static final String REMOTE_PREFIX = "remote";
    public static final String SESSION_USER = "user";
    public static final String SESSION_HOST = "host";
    public static final String SESSION_INSTANCES = "instances";
    public static final String SESSION_KEY_FILE = "ssh_key_file";
    public static final String PATTERN_PREFIX = "output.pattern";
    public static final String PATTERN = "pattern";
    public static final String PATH = "path";
    public static final String HEADER = "header";
    public static final String CONCATENATE = "concatenate";
    private String modelArchive;
    private String sshKeyDir;
    private String outDir;
    private String paramsFile;
    private String vmArgs;
    private float pollFrequency;
    private List<? extends Session> sessions;
    private List<OutputPattern> patterns = new ArrayList<OutputPattern>();

    public Configuration(String file) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(file));
        this.modelArchive = props.getProperty(MA_KEY);
        if (this.modelArchive == null) {
            throw new IOException("Invalid configuration file: file is missing model.archive property");
        }
        props.remove(MA_KEY);
        this.sshKeyDir = props.getProperty(SSH_DIR_KEY);
        if (this.sshKeyDir == null) {
            throw new IOException("Invalid configuration file: file is missing ssh.key_dir property");
        }
        this.sshKeyDir = this.sshKeyDir.trim();
        if (this.sshKeyDir.contains("~")) {
            this.sshKeyDir = this.sshKeyDir.replace("~", System.getProperty("user.home"));
        }
        props.remove(SSH_DIR_KEY);
        this.outDir = props.getProperty(OUT_DIR_KEY);
        if (this.outDir == null) {
            throw new IOException("Invalid configuration file: file is missing model.output property");
        }
        props.remove(OUT_DIR_KEY);
        this.paramsFile = props.getProperty(BATCH_PARAMS_KEY);
        if (this.paramsFile == null) {
            throw new IOException("Invalid configuration file: file is missing batch.params.file property");
        }
        props.remove(BATCH_PARAMS_KEY);
        String sPoll = props.getProperty(POLL_INTERVAL_KEY);
        if (sPoll == null) {
            throw new IOException("Invalid configuration file: file is missing poll.frequency property");
        }
        try {
            this.pollFrequency = Float.parseFloat(sPoll);
        }
        catch (NumberFormatException ex) {
            throw new IOException("Invalid configuration file: poll.frequency property must be a number");
        }
        props.remove(POLL_INTERVAL_KEY);
        this.vmArgs = props.getProperty(VM_ARGS_KEY);
        if (this.vmArgs == null) {
            throw new IOException("Invalid configuration file: file is missing vm.arguments property");
        }
        props.remove(VM_ARGS_KEY);
        this.parseOutputPatterns(props);
        this.sessions = new SessionPropsParser().parse(props);
    }

    private void parseOutputPatterns(Properties props) throws IOException {
        Properties patternProps = new Properties();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(PATTERN_PREFIX)) continue;
            patternProps.setProperty(key, props.getProperty(key));
            toRemove.add(key);
        }
        for (String key : toRemove) {
            props.remove(key);
        }
        OutputPatternPropsParser parser = new OutputPatternPropsParser();
        this.patterns = parser.parse(patternProps);
    }

    public List<OutputPattern> getOutputPatterns() {
        return new ArrayList<OutputPattern>(this.patterns);
    }

    public String getModelArchive() {
        return this.modelArchive;
    }

    public String getBatchParamsFile() {
        return this.paramsFile;
    }

    public String getSSHKeyDir() {
        return this.sshKeyDir;
    }

    public String getOutputDir() {
        return this.outDir;
    }

    public float getPollFrequency() {
        return this.pollFrequency;
    }

    public int getRemoteCount() {
        return this.sessions.size();
    }

    public String getVMArguments() {
        return this.vmArgs;
    }

    public Iterable<? extends Session> sessions() {
        return this.sessions;
    }
}

