/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.parameter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.xml.XMLSweeperProducer;

public class ParametersToInput {
    private XMLSweeperProducer producer;
    private int batchRun;
    private List<String> paramNames = new ArrayList<String>();

    public ParametersToInput(File paramsFile) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        this.producer = new XMLSweeperProducer(paramsFile.toURI().toURL());
    }

    public ParametersToInput(InputStream in) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        this.producer = new XMLSweeperProducer(in);
    }

    public Iterator<String> formatForInput() throws IOException {
        return new Iter(this.producer);
    }

    public void formatForInput(File output, File batchMapFile) throws IOException {
        this.batchRun = 1;
        Parameters params = this.producer.getParameters();
        this.paramNames.clear();
        for (String pName : params.getSchema().parameterNames()) {
            this.paramNames.add(pName);
        }
        ParameterTreeSweeper sweeper = this.producer.getParameterSweeper();
        BufferedWriter hWriter = null;
        BufferedWriter mWriter = null;
        try {
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            hWriter = new BufferedWriter(new FileWriter(output));
            mWriter = new BufferedWriter(new FileWriter(batchMapFile));
            this.writeHeader(mWriter);
            while (!sweeper.atEnd()) {
                sweeper.next(params);
                this.write(hWriter, params);
                this.writeMapFormat(mWriter, params);
                ++this.batchRun;
            }
        }
        finally {
            if (hWriter != null) {
                hWriter.close();
            }
            if (mWriter != null) {
                mWriter.close();
            }
        }
    }

    private void writeHeader(BufferedWriter writer) throws IOException {
        writer.write("run");
        for (String pName : this.paramNames) {
            writer.write(",");
            writer.write("\"");
            writer.write(pName);
            writer.write("\"");
        }
        writer.append("\n");
    }

    private void writeMapFormat(BufferedWriter writer, Parameters params) throws IOException {
        writer.write(String.valueOf(this.batchRun));
        for (String pName : this.paramNames) {
            writer.write(",");
            writer.write(params.getValueAsString(pName));
        }
        writer.append("\n");
    }

    private void write(Writer writer, Parameters params) throws IOException {
        writer.write(String.valueOf(this.batchRun));
        writer.write("\t");
        boolean addComma = false;
        for (String pName : this.paramNames) {
            if (addComma) {
                writer.write(",");
            }
            writer.write(pName);
            writer.append("\t");
            writer.append(params.getValueAsString(pName));
            addComma = true;
        }
        writer.append("\n");
    }

    public static void main(String[] args) {
        File params = new File(args[0]);
        File output = new File(args[1]);
        File mapFile = new File(args[2]);
        try {
            new ParametersToInput(params).formatForInput(output, mapFile);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private static class Iter
    implements Iterator<String> {
        private int batchRun = 1;
        private List<String> paramNames = new ArrayList<String>();
        private Parameters params;
        private ParameterTreeSweeper sweeper;
        private String next = null;

        public Iter(XMLSweeperProducer producer) throws IOException {
            this.params = producer.getParameters();
            for (String pName : this.params.getSchema().parameterNames()) {
                this.paramNames.add(pName);
            }
            this.sweeper = producer.getParameterSweeper();
            this.formatNext();
        }

        private void formatNext() {
            this.next = null;
            if (!this.sweeper.atEnd()) {
                this.sweeper.next(this.params);
                StringBuilder buf = new StringBuilder(String.valueOf(this.batchRun));
                buf.append("\t");
                boolean addComma = false;
                for (String pName : this.paramNames) {
                    if (addComma) {
                        buf.append(",");
                    }
                    buf.append(pName);
                    buf.append("\t");
                    buf.append(this.params.getValueAsString(pName));
                    addComma = true;
                }
                ++this.batchRun;
                this.next = buf.toString();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String tmp = this.next;
            this.formatNext();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

