/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;

    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            String record = this.toString();
            super.reset();
            if (record.length() == 0 || record.equals(this.lineSeparator)) {
                return;
            }
            this.logger.log((Priority)this.level, (Object)record);
        }
    }
}

