/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import repast.simphony.batch.BatchConstants;
import repast.simphony.batch.OneRunBatchRunner;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.parameter.ParameterLineParser;
import repast.simphony.parameter.Parameters;
import repast.simphony.scenario.ScenarioLoadException;
import simphony.util.messages.MessageCenter;
import simphony.util.messages.MessageEvent;
import simphony.util.messages.MessageEventListener;

public class InstanceRunner {
    private static MessageCenter msg = MessageCenter.getMessageCenter(InstanceRunner.class);
    private static final String PXML = "pxml";
    private static final String ID = "id";
    private static final String SCENARIO = "scenario";
    private static final String PINPUT = "pinput";
    private String input;
    private boolean isFileInput = false;
    private ParameterLineParser lineParser;
    private OneRunBatchRunner runner;
    private String id;
    private RunningStatus status = RunningStatus.OK;
    private Options options;

    public InstanceRunner() throws IOException {
        Properties props = new Properties();
        File in = new File("../MessageCenter.log4j.properties");
        props.load(new FileInputStream(in));
        PropertyConfigurator.configure((Properties)props);
        MessageCenter.addMessageListener((MessageEventListener)new MessageEventListener(){

            public void messageReceived(MessageEvent evt) {
                Level level = evt.getLevel();
                if (level == Level.ERROR || level == Level.WARN || level == Level.FATAL) {
                    if (level == Level.WARN && InstanceRunner.this.status == RunningStatus.OK) {
                        InstanceRunner.this.status = RunningStatus.WARN;
                    } else if (level != Level.WARN) {
                        InstanceRunner.this.status = RunningStatus.FAILURE;
                    }
                    InstanceRunner.this.writeMessage(evt);
                }
            }
        });
        this.initOptions();
    }

    private void initOptions() {
        this.options = new Options();
        Option help = new Option("help", "print this message");
        this.options.addOption(help);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given parameter xml file");
        Option pxml = OptionBuilder.create((String)PXML);
        this.options.addOption(pxml);
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given scenario");
        Option scenario = OptionBuilder.create((String)SCENARIO);
        this.options.addOption(scenario);
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given value as instance id");
        Option id = OptionBuilder.create((String)ID);
        this.options.addOption(id);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file as run parameter input");
        Option pinput = OptionBuilder.create((String)PINPUT);
        this.options.addOption(pinput);
    }

    private void writeMessage(MessageEvent evt) {
        String fname = this.status.toString();
        File file = new File(String.valueOf(fname) + "_" + this.id);
        boolean append = file.exists();
        try (PrintWriter writer = null;){
            try {
                writer = new PrintWriter(new FileWriter(file, append));
                writer.append(evt.getMessage().toString());
                writer.append("\n");
                if (evt.getThrowable() != null) {
                    evt.getThrowable().printStackTrace(writer);
                }
            }
            catch (IOException ex) {
                if (evt.getThrowable() != null) {
                    evt.getThrowable().printStackTrace();
                }
                ex.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public void configure(String[] args) throws IOException, ScenarioLoadException {
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (!line.hasOption(PXML)) {
                throw new ScenarioLoadException("Command line is missing required -pxml option");
            }
            String paramFile = line.getOptionValue(PXML);
            File params = new File(paramFile);
            this.lineParser = new ParameterLineParser(params.toURI());
            if (!line.hasOption(SCENARIO)) {
                throw new ScenarioLoadException("Command line is missing required -scenario option");
            }
            File scenario = new File(line.getOptionValue(SCENARIO));
            this.runner = new OneRunBatchRunner(scenario);
            if (!line.hasOption(ID)) {
                throw new ScenarioLoadException("Command line is missing required -id option");
            }
            this.id = line.getOptionValue(ID);
            if (line.hasOption(PINPUT)) {
                this.input = line.getOptionValue(PINPUT);
                this.isFileInput = true;
            } else {
                String[] otherArgs = line.getArgs();
                this.input = otherArgs[otherArgs.length - 1];
            }
        }
        catch (ParseException ex) {
            throw new ScenarioLoadException("Error while parsing command line args", (Throwable)ex);
        }
    }

    public void run() throws ScenarioLoadException {
        this.runner.batchInit();
        String line = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(this.isFileInput ? new FileReader(this.input) : new StringReader(this.input));){
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() <= 0) continue;
                    Parameters params = this.lineParser.parse(line);
                    int runNum = (Integer)params.getValue(BatchConstants.BATCH_RUN_PARAM_NAME);
                    this.runner.run(runNum, params);
                    if (this.status != RunningStatus.FAILURE) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new ScenarioLoadException("Error while reading parameter input", (Throwable)ex);
        }
        this.runner.batchCleanup();
    }

    public static void main(String[] args) {
        try {
            InstanceRunner runner = new InstanceRunner();
            runner.configure(args);
            runner.run();
        }
        catch (Throwable ex) {
            msg.error((Object)"Error while running model", ex, new Object[0]);
        }
    }
}

