/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import repast.simphony.batch.ssh.BatchParameterChunker;
import repast.simphony.batch.ssh.BatchParameterChunkerException;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.ModelArchiveConfigurator;
import repast.simphony.batch.ssh.ModelArchiveConfiguratorException;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.Session;

public class ConfigTest {
    private static String[] EXPECTED_1 = new String[]{"1\trandomSeed\t1,human_count\t100,zombie_count\t1", "2\trandomSeed\t1,human_count\t100,zombie_count\t2", "3\trandomSeed\t1,human_count\t100,zombie_count\t3", "4\trandomSeed\t1,human_count\t100,zombie_count\t4", "5\trandomSeed\t1,human_count\t100,zombie_count\t5", "6\trandomSeed\t1,human_count\t100,zombie_count\t6", "7\trandomSeed\t1,human_count\t100,zombie_count\t7", "8\trandomSeed\t1,human_count\t100,zombie_count\t8", "9\trandomSeed\t1,human_count\t100,zombie_count\t9", "10\trandomSeed\t1,human_count\t100,zombie_count\t10", "11\trandomSeed\t1,human_count\t100,zombie_count\t11", "12\trandomSeed\t1,human_count\t120,zombie_count\t1"};
    private static String[] EXPECTED_2 = new String[]{"13\trandomSeed\t1,human_count\t120,zombie_count\t2", "14\trandomSeed\t1,human_count\t120,zombie_count\t3", "15\trandomSeed\t1,human_count\t120,zombie_count\t4", "16\trandomSeed\t1,human_count\t120,zombie_count\t5"};
    private static String[] EXPECTED_3 = new String[]{"17\trandomSeed\t1,human_count\t120,zombie_count\t6", "18\trandomSeed\t1,human_count\t120,zombie_count\t7", "19\trandomSeed\t1,human_count\t120,zombie_count\t8", "20\trandomSeed\t1,human_count\t120,zombie_count\t9", "21\trandomSeed\t1,human_count\t120,zombie_count\t10", "22\trandomSeed\t1,human_count\t120,zombie_count\t11"};
    private static String[] OUTPUT_1 = new String[]{"**/output/AgentStats.csv", "agent_stat_output", "true", "true"};
    private static String[] OUTPUT_2 = new String[]{"EnvironmentStats.csv", "env_stat_output", "false", "true"};
    private static String[] OUTPUT_3 = new String[]{"Logging.csv", "Logging.csv", "true", "true"};

    @Test
    public void testArchiveConfigurator() throws BatchParameterChunkerException, IOException, ModelArchiveConfiguratorException {
        Configuration config = new Configuration("./test_data/test_config.properties");
        BatchParameterChunker chunker = new BatchParameterChunker(config);
        chunker.run();
        Iterator<? extends Session> iter = config.sessions().iterator();
        Session r1 = iter.next();
        ModelArchiveConfigurator archConfig = new ModelArchiveConfigurator();
        System.out.println(archConfig.configure(r1, config));
    }

    private List<String> getFileContents(String file) {
        ArrayList<String> contents = new ArrayList<String>();
        String line = null;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(file)));){
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    contents.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        return contents;
    }

    @Test
    public void testChunker() throws BatchParameterChunkerException, IOException {
        Configuration config = new Configuration("./test_data/test_config.properties");
        BatchParameterChunker chunker = new BatchParameterChunker(config);
        chunker.run();
        Session session1 = this.findSession(config, "sshtesting", "128.135.250.205");
        Assert.assertNotNull((Object)session1);
        Session session2 = this.findSession(config, "nick", "192.168.1.12");
        Assert.assertNotNull((Object)session2);
        Session session3 = this.findSession(config, System.getProperty("user.name"), "localhost");
        Assert.assertNotNull((Object)session3);
        List<String> contents = this.getFileContents(session1.getInput());
        Assert.assertEquals((long)EXPECTED_1.length, (long)contents.size());
        int i = 0;
        while (i < contents.size()) {
            Assert.assertEquals((Object)EXPECTED_1[i], (Object)contents.get(i));
            ++i;
        }
        contents = this.getFileContents(session2.getInput());
        Assert.assertEquals((long)EXPECTED_2.length, (long)contents.size());
        i = 0;
        while (i < contents.size()) {
            Assert.assertEquals((Object)EXPECTED_2[i], (Object)contents.get(i));
            ++i;
        }
        contents = this.getFileContents(session3.getInput());
        Assert.assertEquals((long)EXPECTED_3.length, (long)contents.size());
        i = 0;
        while (i < contents.size()) {
            Assert.assertEquals((Object)EXPECTED_3[i], (Object)contents.get(i));
            ++i;
        }
    }

    public Session findSession(Configuration config, String user, String host) {
        for (Session session : config.sessions()) {
            if (!session.getUser().equals(user) || !session.getHost().equals(host)) continue;
            return session;
        }
        return null;
    }

    @Test
    public void testConfig() throws IOException {
        Configuration config = new Configuration("./test_data/test_config_with_patterns.properties");
        Assert.assertEquals((Object)"./test_data/complete_model.jar", (Object)config.getModelArchive());
        Assert.assertEquals((Object)"./output", (Object)config.getOutputDir());
        String keydir = "/Users/nick/.ssh";
        Assert.assertEquals((Object)keydir, (Object)config.getSSHKeyDir());
        Assert.assertEquals((float)6.0f, (float)config.getPollFrequency(), (float)0.0f);
        Assert.assertEquals((Object)"scenario.rs/batch_params.xml", (Object)config.getBatchParamsFile());
        List<OutputPattern> patterns = config.getOutputPatterns();
        Assert.assertEquals((long)3L, (long)patterns.size());
        HashMap<String, String[]> expected = new HashMap<String, String[]>();
        expected.put(OUTPUT_1[1], OUTPUT_1);
        expected.put(OUTPUT_2[1], OUTPUT_2);
        expected.put(OUTPUT_3[1], OUTPUT_3);
        for (OutputPattern pattern : patterns) {
            String[] vals = (String[])expected.remove(pattern.getPath());
            Assert.assertTrue((vals != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)vals[0], (Object)pattern.getPattern());
            Assert.assertEquals((Object)vals[1], (Object)pattern.getPath());
            Assert.assertEquals((Object)Boolean.parseBoolean(vals[3]), (Object)pattern.isHeader());
            Assert.assertEquals((Object)Boolean.parseBoolean(vals[2]), (Object)pattern.isConcatenate());
        }
        int count = 0;
        for (Session session : config.sessions()) {
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        Session session = this.findSession(config, "sshtesting", "128.135.250.205");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"128.135.250.205", (Object)session.getHost());
        Assert.assertEquals((Object)"sshtesting", (Object)session.getUser());
        Assert.assertEquals((long)4L, (long)session.getInstances());
        Session session2 = this.findSession(config, "nick", "192.168.1.12");
        Assert.assertNotNull((Object)session2);
        Assert.assertEquals((Object)"nick", (Object)session2.getUser());
        Assert.assertEquals((Object)"192.168.1.12", (Object)session2.getHost());
        Assert.assertEquals((long)2L, (long)session2.getInstances());
        String user = System.getProperty("user.name");
        Session session3 = this.findSession(config, user, "localhost");
        Assert.assertNotNull((Object)session3);
        Assert.assertEquals((Object)user, (Object)session3.getUser());
        Assert.assertEquals((Object)"localhost", (Object)session3.getHost());
        Assert.assertEquals((long)3L, (long)session3.getInstances());
    }
}

