/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.engine.CustomDataSourceDefinition;
import repast.simphony.data2.engine.DataSetComponentControllerAction;
import repast.simphony.data2.engine.DataSetDescriptor;
import repast.simphony.data2.engine.MethodDataSourceDefinition;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;

public class DataUtilities {
    public static List<DataSetDescriptor> getDataSetDescriptors(ControllerRegistry reg, Object contextId) {
        ArrayList<DataSetDescriptor> descriptors = new ArrayList<DataSetDescriptor>();
        ControllerAction parent = reg.findAction(contextId, "repast.controller.action.data_sets");
        for (ControllerAction action : reg.getActionTree(contextId).getChildren((Object)parent)) {
            if (!(action instanceof DataSetComponentControllerAction)) continue;
            descriptors.add(((DataSetComponentControllerAction)action).getDescriptor());
        }
        return descriptors;
    }

    public static boolean isNumeric(CustomDataSourceDefinition def) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cname = def.getDataSourceClassName();
        Class<?> clazz = Class.forName(cname);
        DataSource source = (DataSource)clazz.newInstance();
        Class<?> dataType = source.getDataType();
        if (dataType.isPrimitive() && !dataType.equals(Void.TYPE) && !dataType.equals(Boolean.TYPE)) {
            return true;
        }
        return Number.class.isAssignableFrom(source.getDataType());
    }

    public static boolean isNumeric(Class<?> dataType) {
        if (dataType.isPrimitive() && !dataType.equals(Void.TYPE) && !dataType.equals(Boolean.TYPE)) {
            return true;
        }
        return Number.class.isAssignableFrom(dataType);
    }

    public static boolean isNumeric(MethodDataSourceDefinition def) throws ClassNotFoundException {
        String cname = def.getObjTargetClass();
        Class<?> clazz = Class.forName(cname);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && method.getName().equals(def.getMethodName())) {
                Class<?> ret = method.getReturnType();
                if (ret.isPrimitive() && !ret.equals(Void.TYPE) && !ret.equals(Boolean.TYPE)) {
                    return true;
                }
                return Number.class.isAssignableFrom(ret);
            }
            ++n2;
        }
        return false;
    }

    public static void renameFileIfExists(String filename) {
        File originalFile = new File(filename);
        if (!originalFile.exists()) {
            return;
        }
        File movedFileName = new File(originalFile.getAbsolutePath());
        long i = 0L;
        while (movedFileName.exists()) {
            int index = filename.lastIndexOf(".");
            if (index != -1) {
                movedFileName = new File(String.valueOf(filename.substring(0, index)) + "." + i + filename.substring(index, filename.length()));
            } else {
                filename = String.valueOf(filename) + "." + i;
            }
            ++i;
        }
        originalFile.renameTo(movedFileName);
    }
}

