/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.util;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.engine.CustomDataSourceDefinition;
import repast.simphony.data2.engine.MethodDataSourceDefinition;

public class AggregateFilter {
    private static Set<Class<?>> allowable = new HashSet();

    static {
        allowable.add(Object.class);
        allowable.add(Integer.TYPE);
        allowable.add(Long.TYPE);
        allowable.add(Float.TYPE);
        allowable.add(Byte.TYPE);
        allowable.add(Short.TYPE);
        allowable.add(Double.TYPE);
        allowable.add(Boolean.TYPE);
        allowable.add(Boolean.class);
    }

    public boolean check(Class<?> clazz) {
        if (allowable.contains(clazz)) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public boolean check(CustomDataSourceDefinition def) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cname = def.getDataSourceClassName();
        Class<?> clazz = Class.forName(cname);
        DataSource source = (DataSource)clazz.newInstance();
        Class<?> dataType = source.getDataType();
        return this.check(dataType);
    }

    public boolean check(MethodDataSourceDefinition def) throws ClassNotFoundException {
        String cname = def.getObjTargetClass();
        Class<?> clazz = Class.forName(cname);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && method.getName().equals(def.getMethodName())) {
                Class<?> ret = method.getReturnType();
                return this.check(ret);
            }
            ++n2;
        }
        return false;
    }
}

