/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.data2.AggregateOp;
import repast.simphony.data2.engine.CountSourceDefinition;
import repast.simphony.data2.engine.CustomDataSourceDefinition;
import repast.simphony.data2.engine.MethodDataSourceDefinition;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.scenario.AbstractDescriptor;
import repast.simphony.util.collections.IterableAdaptor;

public class DataSetDescriptor
extends AbstractDescriptor {
    private DataSetType type = DataSetType.AGGREGATE;
    private String sourceType;
    private boolean inclTick;
    private boolean inclBatchRun;
    private boolean inclRandomSeed;
    private ScheduleParameters scheduleParams = ScheduleParameters.createRepeating((double)1.0, (double)1.0, (double)Double.NEGATIVE_INFINITY);
    private boolean atEnd = false;
    private Map<String, MethodDataSourceDefinition> methodDataSources = new LinkedHashMap<String, MethodDataSourceDefinition>();
    private Map<String, CountSourceDefinition> countSources = new LinkedHashMap<String, CountSourceDefinition>();
    private Map<String, CustomDataSourceDefinition> customNADataSources = new LinkedHashMap<String, CustomDataSourceDefinition>();
    private Map<String, CustomDataSourceDefinition> customAggDataSources = new LinkedHashMap<String, CustomDataSourceDefinition>();

    public DataSetDescriptor(String name) {
        this(name, DataSetType.AGGREGATE);
    }

    public DataSetDescriptor(String name, DataSetType type) {
        super(name);
        this.type = type;
        this.inclTick = true;
    }

    public Iterable<String> dataSourceIds() {
        IteratorChain chain = new IteratorChain(this.methodDataSources.keySet().iterator());
        ArrayList<String> defaultSources = new ArrayList<String>();
        if (this.inclTick) {
            defaultSources.add("tick");
        }
        if (this.inclBatchRun) {
            defaultSources.add("run");
        }
        if (this.inclRandomSeed) {
            defaultSources.add("random_seed");
        }
        chain.addIterator(defaultSources.iterator());
        if (this.type == DataSetType.AGGREGATE) {
            chain.addIterator(this.countSources.keySet().iterator());
            chain.addIterator(this.customAggDataSources.keySet().iterator());
        } else {
            chain.addIterator(this.customNADataSources.keySet().iterator());
        }
        return new IterableAdaptor((Iterator)chain);
    }

    public ScheduleParameters getScheduleParameters() {
        return this.scheduleParams;
    }

    public void addNonAggregateDataSource(String id, String className) {
        this.customNADataSources.put(id, new CustomDataSourceDefinition(id, className));
        this.scs.fireScenarioChanged((Object)this, "customNADataSources");
    }

    public void addAggregateDataSource(String id, String className) {
        this.customAggDataSources.put(id, new CustomDataSourceDefinition(id, className));
        this.scs.fireScenarioChanged((Object)this, "customAggDataSources");
    }

    public void removeCustomDataSource(String id) {
        if (this.customAggDataSources.remove(id) != null) {
            this.scs.fireScenarioChanged((Object)this, "customAggDataSources");
        }
        if (this.customNADataSources.remove(id) != null) {
            this.scs.fireScenarioChanged((Object)this, "customNADataSources");
        }
    }

    public Iterable<CustomDataSourceDefinition> customAggDataSources() {
        return this.customAggDataSources.values();
    }

    public Iterable<CustomDataSourceDefinition> customNonAggDataSources() {
        return this.customNADataSources.values();
    }

    public void setScheduleParameters(ScheduleParameters scheduleParams) {
        if (!this.scheduleParams.equals((Object)scheduleParams)) {
            this.scheduleParams = scheduleParams;
            this.scs.fireScenarioChanged((Object)this, "scheduleParameters");
        }
    }

    public boolean includeTick() {
        return this.inclTick;
    }

    public void setIncludeTick(boolean inclTick) {
        if (this.inclTick != inclTick) {
            this.inclTick = inclTick;
            this.scs.fireScenarioChanged((Object)this, "inclTick");
        }
    }

    public boolean includeBatchRun() {
        return this.inclBatchRun;
    }

    public void setIncludeBatchRun(boolean inclBatchRun) {
        if (this.inclBatchRun != inclBatchRun) {
            this.inclBatchRun = inclBatchRun;
            this.scs.fireScenarioChanged((Object)this, "inclBatchRun");
        }
    }

    public boolean includeRandomSeed() {
        return this.inclRandomSeed;
    }

    public void setIncludeRandomSeed(boolean inclRandomSeed) {
        if (this.inclRandomSeed != inclRandomSeed) {
            this.inclRandomSeed = inclRandomSeed;
            this.scs.fireScenarioChanged((Object)this, "inclRandomSeed");
        }
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        if (this.sourceType == null || !this.sourceType.equals(sourceType)) {
            this.sourceType = sourceType;
            this.scs.fireScenarioChanged((Object)this, "sourceType");
        }
    }

    public DataSetType getType() {
        return this.type;
    }

    public void setType(DataSetType type) {
        if (this.type != type) {
            this.type = type;
            this.scs.fireScenarioChanged((Object)this, "type");
        }
    }

    public boolean isScheduleAtEnd() {
        return this.atEnd;
    }

    public void setScheduleAtEnd(boolean val) {
        if (this.atEnd != val) {
            this.atEnd = val;
            this.scs.fireScenarioChanged((Object)this, "atEnd");
        }
    }

    private void checkId(String id) {
        if (this.methodDataSources.containsKey(id) || this.countSources.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate data source ids ('" + id + "') are not not allowed.");
        }
    }

    public void addMethodDataSource(String id, String className, String methodName) {
        this.checkId(id);
        this.methodDataSources.put(id, new MethodDataSourceDefinition(id, className, methodName));
        this.scs.fireScenarioChanged((Object)this, "methodDataSources");
    }

    public void addAggregateMethodDataSource(String id, String className, String methodName, AggregateOp aggType) {
        if (this.type != DataSetType.AGGREGATE) {
            throw new IllegalArgumentException("Cannot add an aggregate data source in non-aggregate descriptor");
        }
        this.checkId(id);
        MethodDataSourceDefinition mds = new MethodDataSourceDefinition(id, className, methodName);
        mds.setAggregateOp(aggType);
        this.methodDataSources.put(id, mds);
        this.scs.fireScenarioChanged((Object)this, "methodDataSources");
    }

    public void addCountDataSource(String id, String className) {
        if (this.type != DataSetType.AGGREGATE) {
            throw new IllegalArgumentException("Cannot add an aggregate count data source in non-aggregate descriptor");
        }
        this.checkId(id);
        this.countSources.put(id, new CountSourceDefinition(id, className));
        this.scs.fireScenarioChanged((Object)this, "countDataSources");
    }

    public Iterable<CountSourceDefinition> countDataSources() {
        return this.countSources.values();
    }

    public void removeMethodDataSource(String id) {
        if (this.methodDataSources.containsKey(id)) {
            this.methodDataSources.remove(id);
            this.scs.fireScenarioChanged((Object)this, "methodDataSources");
        }
    }

    public void removeCountDataSource(String id) {
        if (this.countSources.containsKey(id)) {
            this.countSources.remove(id);
            this.scs.fireScenarioChanged((Object)this, "countDataSources");
        }
    }

    public Iterable<MethodDataSourceDefinition> methodDataSources() {
        return this.methodDataSources.values();
    }

    public void clearCountDataSources() {
        if (this.countSources.size() > 0) {
            this.countSources.clear();
            this.scs.fireScenarioChanged((Object)this, "countDataSources");
        }
    }

    public void clearMethodDataSources() {
        if (this.methodDataSources.size() > 0) {
            this.methodDataSources.clear();
            this.scs.fireScenarioChanged((Object)this, "methodDataSources");
        }
    }

    public void clearCustomDataSources() {
        if (this.customNADataSources.size() > 0) {
            this.customNADataSources.clear();
            this.scs.fireScenarioChanged((Object)this, "customNADataSources");
        }
        if (this.customAggDataSources.size() > 0) {
            this.customAggDataSources.clear();
            this.scs.fireScenarioChanged((Object)this, "customAggDataSources");
        }
    }

    public static enum DataSetType {
        AGGREGATE,
        NON_AGGREGATE;

    }
}

