/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import repast.simphony.data2.AbstractFormatter;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.FileDataSink;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.LineFormatter;
import repast.simphony.data2.TabularFormatter;
import repast.simphony.data2.builder.FileNameFormatter;
import repast.simphony.data2.builder.SinkBuilder;
import repast.simphony.data2.util.DataUtilities;

public class FileDataSinkBuilder
implements SinkBuilder {
    private FormatType type;
    private String delimiter;
    private String name;
    private FileNameFormatter fnameFormatter;
    private Set<String> sourceIds = new LinkedHashSet<String>();

    public FileDataSinkBuilder(String name, FileNameFormatter fnameFormatter, String delimiter, FormatType formatType) {
        this.type = formatType;
        this.delimiter = delimiter;
        this.fnameFormatter = fnameFormatter;
        this.name = name;
    }

    public void addSource(String sourceId) {
        this.sourceIds.add(sourceId);
    }

    @Override
    public DataSink create(Collection<? extends DataSource> sources) {
        String filename = this.fnameFormatter.getFilename();
        DataUtilities.renameFileIfExists(filename);
        ArrayList<? extends DataSource> selectedSources = new ArrayList<DataSource>();
        block0: for (String id : this.sourceIds) {
            for (DataSource dataSource : sources) {
                if (!dataSource.getId().equals(id)) continue;
                selectedSources.add(dataSource);
                continue block0;
            }
        }
        if (selectedSources.size() == 0) {
            selectedSources.addAll(sources);
        }
        AbstractFormatter formatter = this.type == FormatType.TABULAR ? new TabularFormatter(selectedSources, this.delimiter) : new LineFormatter(selectedSources, this.delimiter);
        return new FileDataSink(this.name, new File(filename), formatter);
    }
}

