/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import repast.simphony.data2.AbstractFormatter;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.FormatType;

public class TabularFormatter
extends AbstractFormatter {
    public TabularFormatter(Collection<? extends DataSource> sources, String delimiter) {
        super(sources, delimiter);
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.keyMap.keySet());
    }

    @Override
    public String getHeader() {
        Iterator iter = this.keyMap.keySet().iterator();
        StringBuilder builder = new StringBuilder("\"");
        builder.append((String)iter.next());
        builder.append("\"");
        while (iter.hasNext()) {
            builder.append(this.delimiter);
            builder.append("\"");
            builder.append((String)iter.next());
            builder.append("\"");
        }
        return builder.toString();
    }

    @Override
    public String formatData() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.data[0]);
        int i = 1;
        int n = this.data.length;
        while (i < n) {
            builder.append(this.delimiter);
            builder.append(this.data[i]);
            ++i;
        }
        return builder.toString();
    }

    @Override
    public FormatType getFormatType() {
        return FormatType.TABULAR;
    }
}

