/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import repast.simphony.data2.AbstractDataSet;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.NonAggregateDataSource;
import repast.simphony.data2.SizedIterable;

public class NonAggregateDataSet
extends AbstractDataSet {
    private List<NonAggregateDataSource> sources = new ArrayList<NonAggregateDataSource>();
    private Class<?> sourceType;

    public NonAggregateDataSet(String id, Collection<NonAggregateDataSource> sources, Collection<? extends DataSink> sinks) {
        super(id);
        this.sources.addAll(sources);
        this.sinks.addAll(sinks);
        for (DataSource dataSource : sources) {
            if (dataSource.getSourceType().equals(Void.TYPE)) continue;
            this.sourceType = dataSource.getSourceType();
            break;
        }
    }

    @Override
    protected List<String> getSourceIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (NonAggregateDataSource source : this.sources) {
            ids.add(source.getId());
        }
        return ids;
    }

    @Override
    public void record(Map<Class<?>, SizedIterable<?>> objMap) {
        SizedIterable<?> objs = objMap.get(this.sourceType);
        for (Object obj : objs) {
            for (DataSink sink : this.sinks) {
                sink.rowStarted();
            }
            for (NonAggregateDataSource source : this.sources) {
                String id = source.getId();
                Object val = source.get(obj);
                for (DataSink sink : this.sinks) {
                    sink.append(id, val);
                }
            }
            for (DataSink sink : this.sinks) {
                sink.rowEnded();
            }
        }
        for (DataSink sink : this.sinks) {
            sink.recordEnded();
        }
    }

    @Override
    public Iterable<Class<?>> getSourceTypes() {
        ArrayList list = new ArrayList();
        list.add(this.sourceType);
        return list;
    }
}

