/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import repast.simphony.data2.DataException;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.Formatter;

public class FileDataSink
implements DataSink {
    private Formatter formatter;
    private File file;
    private BufferedWriter writer;
    private String name;
    private boolean closed = false;

    public FileDataSink(String name, File file, Formatter formatter) {
        this.formatter = formatter;
        this.file = file;
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public FormatType getFormat() {
        return this.formatter.getFormatType();
    }

    @Override
    public void open(List<String> sourceIds) {
        try {
            File parentFile = this.file.getCanonicalFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.writer = new BufferedWriter(new FileWriter(this.file));
            String header = this.formatter.getHeader();
            if (header.length() > 0) {
                this.writer.write(this.formatter.getHeader());
                this.writer.newLine();
            }
        }
        catch (IOException ex) {
            throw new DataException("Error opening FileDataSink.", ex);
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.closed) {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
            }
            catch (IOException ex) {
                throw new DataException("Error while flushing FileDataSink.", ex);
            }
        }
    }

    @Override
    public void rowStarted() {
        this.formatter.clear();
    }

    @Override
    public void append(String key, Object value) {
        this.formatter.addData(key, value);
    }

    @Override
    public void rowEnded() {
        try {
            this.writer.write(this.formatter.formatData());
            this.writer.newLine();
        }
        catch (IOException ex) {
            throw new DataException("Error writing to FileDataSink '" + this.file.getName() + "'", ex);
        }
    }

    @Override
    public void recordEnded() {
    }

    @Override
    public synchronized void close() {
        if (!this.closed && this.writer != null) {
            try {
                try {
                    this.writer.flush();
                }
                catch (IOException ex) {
                    throw new DataException("Error closing FileDataSink.", ex);
                }
            }
            finally {
                try {
                    this.closed = true;
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

