/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.junit.Assert;
import org.junit.Test;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.data2.AggregateDSCreator;
import repast.simphony.data2.AggregateDataSet;
import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.BatchRunDataSetManager;
import repast.simphony.data2.DataException;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.FileDataSink;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.MethodDataSource;
import repast.simphony.data2.NonAggregateDataSet;
import repast.simphony.data2.NonAggregateDataSource;
import repast.simphony.data2.ObjectA;
import repast.simphony.data2.ObjectB;
import repast.simphony.data2.ObjectC;
import repast.simphony.data2.ParameterDataSource;
import repast.simphony.data2.SingleRunDataSetManager;
import repast.simphony.data2.SizedIterable;
import repast.simphony.data2.TabularFormatter;
import repast.simphony.data2.engine.DataInitActionCreator;
import repast.simphony.data2.engine.DataSetComponentControllerAction;
import repast.simphony.data2.engine.DataSetDescriptor;
import repast.simphony.data2.engine.DataSetsActionCreator;
import repast.simphony.data2.engine.FileSinkComponentControllerAction;
import repast.simphony.data2.engine.FileSinkDescriptor;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.DefaultGUIRegistry;
import repast.simphony.engine.environment.DefaultScheduleRegistry;
import repast.simphony.engine.environment.GUIRegistry;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunInfo;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.environment.ScheduleRegistry;
import repast.simphony.engine.schedule.DefaultScheduleFactory;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.parameter.DefaultParameters;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;

public class DataTests {
    private static SizedIterable<Object> NULL_SIZED_ITERABLE = new SizedIterable<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return null;
        }
    };
    private int[][] data;

    public DataTests() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{234, 23, 14};
        nArrayArray[1] = new int[]{53, 31, 100};
        int[] nArray = new int[3];
        nArray[0] = 12;
        nArray[2] = -2;
        nArrayArray[2] = nArray;
        this.data = nArrayArray;
    }

    @Test
    public void testMethodDS() {
        ObjectA a = new ObjectA();
        MethodDataSource source = new MethodDataSource("double", ObjectA.class, "getDouble");
        Assert.assertEquals((Object)a.getDouble(), (Object)source.get(a));
        ObjectB b = new ObjectB();
        source = new MethodDataSource("double", ObjectB.class, "getDouble");
        Assert.assertEquals((Object)b.getDouble(), (Object)source.get(b));
        source = new MethodDataSource("double", ObjectA.class, "getDouble");
        Assert.assertEquals((Object)b.getDouble(), (Object)source.get(b));
        try {
            source = new MethodDataSource("foo", ObjectA.class, "foo");
            Assert.fail();
        }
        catch (DataException dataException) {
            // empty catch block
        }
        MethodDataSource osource = new MethodDataSource("object", ObjectB.class, "object");
        Assert.assertEquals((Object)b.object(), (Object)osource.get(b));
        try {
            osource.get(a);
            Assert.fail();
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    private Map<Class<?>, SizedIterable<?>> createRecordMap(final List<?> list, Class<?> clazz) {
        HashMap map = new HashMap();
        map.put(clazz, new SizedIterable(){

            @Override
            public Iterator iterator() {
                return list.iterator();
            }

            @Override
            public int size() {
                return list.size();
            }
        });
        return map;
    }

    @Test
    public void testNonAggregate() {
        ArrayList<ObjectB> objs = new ArrayList<ObjectB>();
        objs.add(new ObjectB());
        objs.add(new ObjectB());
        objs.add(new ObjectB());
        ArrayList<NonAggregateDataSource> sources = new ArrayList<NonAggregateDataSource>();
        sources.add(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(new MethodDataSource("object", ObjectB.class, "object"));
        sources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        ArrayList<Sink> sinks = new ArrayList<Sink>();
        sinks.add(new Sink());
        sinks.add(new Sink());
        NonAggregateDataSet dataSet = new NonAggregateDataSet("ds1", sources, sinks);
        dataSet.init();
        int i = 0;
        while (i < 3) {
            dataSet.record(this.createRecordMap(objs, ObjectB.class));
            ++i;
        }
        dataSet.close();
        for (Sink sink : sinks) {
            Assert.assertTrue((boolean)sink.opened);
            Assert.assertTrue((boolean)sink.closed);
            HashSet expected = new HashSet();
            Assert.assertEquals((long)sink.items.size(), (long)9L);
            for (Map<String, Object> map : sink.items) {
                Assert.assertEquals((long)map.size(), (long)3L);
                Assert.assertTrue((boolean)map.containsKey("double"));
                Assert.assertTrue((boolean)map.containsKey("object"));
                Assert.assertTrue((boolean)map.containsKey("int"));
                Assert.assertEquals((double)((Double)map.get("double")), (double)3.14, (double)1.0E-4);
                Assert.assertEquals((long)((Integer)map.get("int")).intValue(), (long)3L);
                Assert.assertEquals((Object)((String)map.get("object")), (Object)"hello");
                Assert.assertEquals((long)expected.size(), (long)0L);
            }
        }
    }

    @Test
    public void testAggregateDSBoolObj() {
        ArrayList<ObjectC> objs = new ArrayList<ObjectC>();
        ObjectC obj = new ObjectC();
        obj.val = true;
        objs.add(obj);
        objs.add(new ObjectC());
        objs.add(new ObjectC());
        AggregateDSCreator creator = new AggregateDSCreator(new MethodDataSource("obj", ObjectC.class, "getObj"));
        AggregateDataSource ds = creator.createSumSource("sum");
        ds.reset();
        Double val = (Double)ds.get(objs, objs.size());
        Assert.assertEquals((double)9.0, (double)val, (double)0.0);
        creator = new AggregateDSCreator(new MethodDataSource("bool", ObjectC.class, "getBool"));
        ds = creator.createSumSource("sum");
        val = (Double)ds.get(objs, objs.size());
        Assert.assertEquals((double)1.0, (double)val, (double)0.0);
    }

    @Test
    public void testAggregateDS() {
        ArrayList<ObjectB> objs = new ArrayList<ObjectB>();
        objs.add(new ObjectB());
        objs.add(new ObjectB());
        objs.add(new ObjectB());
        ArrayList<Sink> sinks = new ArrayList<Sink>();
        sinks.add(new Sink());
        sinks.add(new Sink());
        ArrayList<AggregateDataSource> sources = new ArrayList<AggregateDataSource>();
        AggregateDSCreator creator = new AggregateDSCreator(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(creator.createSumSource("double_sum"));
        sources.add(creator.createMeanSource("double_mean"));
        sources.add(creator.createMinSource("double_min"));
        sources.add(creator.createMaxSource("double_max"));
        creator = new AggregateDSCreator(new MethodDataSource("int", ObjectB.class, "getInt"));
        sources.add(creator.createSumSource("int_sum"));
        sources.add(creator.createMeanSource("int_mean"));
        AggregateDataSet dataSet = new AggregateDataSet("ds1", sources, sinks);
        dataSet.init();
        SummaryStatistics stats = new SummaryStatistics();
        double[][] expected = new double[3][];
        int i = 0;
        while (i < 3) {
            stats.clear();
            ((ObjectB)objs.get(0)).setDouble(this.data[i][0]);
            stats.addValue((double)this.data[i][0]);
            ((ObjectB)objs.get(1)).setDouble(this.data[i][1]);
            stats.addValue((double)this.data[i][1]);
            ((ObjectB)objs.get(2)).setDouble(this.data[i][2]);
            stats.addValue((double)this.data[i][2]);
            ((ObjectB)objs.get(0)).setInt(this.data[i][0]);
            ((ObjectB)objs.get(1)).setInt(this.data[i][1]);
            ((ObjectB)objs.get(2)).setInt(this.data[i][2]);
            dataSet.record(this.createRecordMap(objs, ObjectB.class));
            expected[i] = new double[]{stats.getSum(), stats.getMean(), stats.getMin(), stats.getMax()};
            ++i;
        }
        dataSet.close();
        for (Sink sink : sinks) {
            Assert.assertEquals((Object)sink.opened, (Object)true);
            Assert.assertEquals((Object)sink.closed, (Object)true);
            Assert.assertEquals((long)sink.items.size(), (long)3L);
            int i2 = 0;
            for (Map<String, Object> map : sink.items) {
                Assert.assertEquals((long)map.size(), (long)6L);
                Assert.assertEquals((Object)map.containsKey("double_sum"), (Object)true);
                Assert.assertEquals((Object)map.containsKey("double_min"), (Object)true);
                Assert.assertEquals((Object)map.containsKey("double_max"), (Object)true);
                Assert.assertEquals((Object)map.containsKey("double_mean"), (Object)true);
                Assert.assertEquals((Object)map.containsKey("int_sum"), (Object)true);
                Assert.assertEquals((Object)map.containsKey("int_mean"), (Object)true);
                Assert.assertEquals((double)((Double)map.get("double_sum")), (double)expected[i2][0], (double)0.0);
                Assert.assertEquals((double)((Double)map.get("double_mean")), (double)expected[i2][1], (double)0.0);
                Assert.assertEquals((double)((Double)map.get("double_min")), (double)expected[i2][2], (double)0.0);
                Assert.assertEquals((double)((Double)map.get("double_max")), (double)expected[i2][3], (double)0.0);
                Assert.assertEquals((double)((Number)map.get("int_sum")).doubleValue(), (double)expected[i2][0], (double)0.0);
                Assert.assertEquals((double)((Number)map.get("int_mean")).doubleValue(), (double)expected[i2][1], (double)0.0);
                ++i2;
            }
        }
    }

    @Test
    public void testFormatter() {
        ArrayList<MethodDataSource> sources = new ArrayList<MethodDataSource>();
        sources.add(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(new MethodDataSource("object", ObjectB.class, "object"));
        sources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        TabularFormatter formatter = new TabularFormatter(sources, ",");
        Assert.assertEquals((Object)formatter.getHeader(), (Object)"\"double\",\"object\",\"int\"");
        formatter.addData("double", 3.14);
        formatter.addData("object", "Hello");
        formatter.addData("int", 10);
        Assert.assertEquals((Object)formatter.formatData(), (Object)"3.14,\"Hello\",10");
        formatter.clear();
        formatter.addData("int", 1000);
        formatter.addData("object", "Goodbye");
        formatter.addData("double", 5.14);
        Assert.assertEquals((Object)formatter.formatData(), (Object)"5.14,\"Goodbye\",1000");
    }

    @Test
    public void testFileSink() {
        ArrayList<MethodDataSource> sources = new ArrayList<MethodDataSource>();
        sources.add(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(new MethodDataSource("object", ObjectB.class, "object"));
        sources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        File file = new File("./test_output/file_sink_test.txt");
        FileDataSink sink = new FileDataSink("fs1", file, new TabularFormatter(sources, ","));
        sink.open(new ArrayList<String>());
        sink.rowStarted();
        sink.append("double", 3.14);
        sink.append("object", "hello");
        sink.append("int", 1000);
        sink.rowEnded();
        sink.rowStarted();
        sink.append("int", 103);
        sink.append("double", 2.14);
        sink.append("object", "bug");
        sink.rowEnded();
        sink.close();
        String[] expected = new String[]{"\"double\",\"object\",\"int\"", "3.14,\"hello\",1000", "2.14,\"bug\",103"};
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    Assert.assertEquals((Object)expected[i], (Object)line);
                    ++i;
                }
                Assert.assertEquals((long)i, (long)3L);
            }
            catch (IOException ex) {
                Assert.fail();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private RunState createRunState(int runNum, RunState runState) {
        if (runState == null) {
            runState = RunState.init((RunInfo)new RunInfo("test", runNum, 1), (ScheduleRegistry)new DefaultScheduleRegistry(), (GUIRegistry)new DefaultGUIRegistry());
        } else {
            runState.getRunInfo().setRunNumber(runNum);
        }
        ISchedule schedule = new DefaultScheduleFactory().createSchedule();
        schedule.schedule(ScheduleParameters.createRepeating((double)1.0, (double)1.0), new IAction(){

            public void execute() {
            }
        });
        runState.getScheduleRegistry().setModelSchedule(schedule);
        return runState;
    }

    private Parameters createParameters() {
        DefaultParameters params = new DefaultParameters();
        params.addParameter("randomSeed", "Default Random Seed", Integer.class, (Object)1, false);
        return params;
    }

    private List<ObjectB> createObjs() {
        ArrayList<ObjectB> objs = new ArrayList<ObjectB>();
        objs.add(new ObjectB("A"));
        objs.add(new ObjectB("B"));
        objs.add(new ObjectB("C"));
        return objs;
    }

    @Test
    public void testAction() throws IOException {
        try {
            DataSetDescriptor descriptor = new DataSetDescriptor("ds1", DataSetDescriptor.DataSetType.NON_AGGREGATE);
            descriptor.setIncludeRandomSeed(true);
            descriptor.setIncludeTick(true);
            descriptor.addMethodDataSource("double", ObjectB.class.getName(), "getDouble");
            descriptor.addMethodDataSource("object", ObjectB.class.getName(), "object");
            descriptor.addMethodDataSource("int", ObjectB.class.getName(), "getInt");
            descriptor.setScheduleParameters(ScheduleParameters.createRepeating((double)1.0, (double)1.0));
            descriptor.setSourceType(Object.class.getName());
            DataSetComponentControllerAction dsAction = new DataSetComponentControllerAction(descriptor);
            FileSinkDescriptor fdesc = new FileSinkDescriptor("fs1");
            fdesc.setDataSet("ds1");
            String filename = "./test_output/sr_manager_test.txt";
            fdesc.setFileName(filename);
            fdesc.setAddTimeStamp(false);
            fdesc.setFormat(FormatType.TABULAR);
            fdesc.setDelimiter(",");
            FileSinkComponentControllerAction fsAction = new FileSinkComponentControllerAction(fdesc);
            List<ObjectB> objs = this.createObjs();
            DefaultContext context = new DefaultContext((Object)"root");
            context.addAll(objs);
            RunState runState = this.createRunState(1, null);
            runState.setMasterContext((Context)context);
            ISchedule schedule = runState.getScheduleRegistry().getModelSchedule();
            DataSetsActionCreator dsCreator = new DataSetsActionCreator();
            DataInitActionCreator dsInit = new DataInitActionCreator();
            dsCreator.createControllerAction().batchInitialize(runState, (Object)"root");
            dsAction.batchInitialize(runState, "root");
            fsAction.batchInitialize(runState, "root");
            ControllerAction initAction = dsInit.createControllerAction();
            initAction.batchInitialize(runState, (Object)"root");
            initAction.runInitialize(runState, (Object)"root", this.createParameters());
            int i = 0;
            while (i < 3) {
                schedule.execute();
                for (ObjectB objB : objs) {
                    objB.setInt(i);
                }
                ++i;
            }
            initAction.runCleanup(runState, (Object)"root");
            initAction.batchCleanup(runState, (Object)"root");
            this.testSRFileOutput(filename);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSRDataManager() throws IOException {
        SingleRunDataSetManager manager = new SingleRunDataSetManager();
        ArrayList<NonAggregateDataSource> sources = new ArrayList<NonAggregateDataSource>();
        sources.add(manager.getTickCountDataSource());
        sources.add(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(new MethodDataSource("object", ObjectB.class, "object"));
        sources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        sources.add(manager.getRandomSeedDataSource());
        ArrayList<DataSink> sinks = new ArrayList<DataSink>();
        String filename = "./test_output/sr_manager_test.txt";
        File file = new File(filename);
        FileDataSink fsink = new FileDataSink("fs1", file, new TabularFormatter(sources, ","));
        sinks.add(fsink);
        Sink sink1 = new Sink();
        sinks.add(sink1);
        NonAggregateDataSet set1 = new NonAggregateDataSet("ds1", sources, sinks);
        manager.addDataSet(set1, ScheduleParameters.createRepeating((double)1.0, (double)1.0), false);
        sinks = new ArrayList();
        Sink sink2 = new Sink();
        sinks.add(sink2);
        NonAggregateDataSet set2 = new NonAggregateDataSet("ds2", sources, sinks);
        manager.addDataSet(set2, ScheduleParameters.createRepeating((double)1.0, (double)1.0), false);
        List<ObjectB> objs = this.createObjs();
        DefaultContext context = new DefaultContext((Object)"root");
        context.addAll(objs);
        RunState runState = this.createRunState(1, null);
        runState.setMasterContext((Context)context);
        ISchedule schedule = runState.getScheduleRegistry().getModelSchedule();
        manager.batchStarted();
        manager.runStarted(runState, "root", this.createParameters());
        Assert.assertEquals((Object)manager.getRandomSeedDataSource().get(null), (Object)1);
        Assert.assertEquals((Object)manager.getRandomSeedDataSource().get(new ArrayList()), (Object)1);
        int i = 0;
        while (i < 3) {
            schedule.execute();
            for (ObjectB objB : objs) {
                objB.setInt(i);
            }
            ++i;
        }
        manager.runEnded(runState, "root");
        manager.batchEnded();
        this.testSRSinks(filename, sink1, sink2);
    }

    private List<String> readLines(String filename) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = null;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    private void testSRFileOutput(String fileName) throws IOException {
        List<String> found = this.readLines(fileName);
        List<String> expectedLines = this.readLines("./test_output/sr_expected.txt");
        Assert.assertEquals((long)found.size(), (long)expectedLines.size());
        int i = 0;
        while (i < found.size()) {
            Assert.assertEquals((Object)found.get(i), (Object)expectedLines.get(i));
            ++i;
        }
    }

    private void testSRSinks(String fileName, Sink sink1, Sink sink2) throws IOException {
        Sink[] sinks = new Sink[]{sink1, sink2};
        List<String> found = this.readLines(fileName);
        List<String> expectedLines = this.readLines("./test_output/sr_expected.txt");
        Assert.assertEquals((long)found.size(), (long)expectedLines.size());
        int i = 0;
        while (i < found.size()) {
            Assert.assertEquals((Object)found.get(i), (Object)expectedLines.get(i));
            ++i;
        }
        ArrayList expected = new ArrayList();
        int i2 = 1;
        while (i2 < found.size()) {
            String[] vals = found.get(i2).split(",");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tick", Double.valueOf(vals[0]));
            map.put("double", Double.valueOf(vals[1]));
            map.put("object", vals[2].substring(1, vals[2].length() - 1));
            map.put("int", Integer.valueOf(vals[3]));
            map.put("random_seed", Integer.valueOf(vals[4]));
            expected.add(map);
            ++i2;
        }
        Assert.assertEquals((long)sink1.items.size(), (long)12L);
        Assert.assertEquals((long)sink2.items.size(), (long)12L);
        Assert.assertEquals((long)expected.size(), (long)12L);
        i2 = 0;
        while (i2 < 9) {
            Sink[] sinkArray = sinks;
            int n = sinks.length;
            int n2 = 0;
            while (n2 < n) {
                Sink sink = sinkArray[n2];
                Map<String, Object> data = sink.items.get(i2);
                Map exp = (Map)expected.get(i2);
                Assert.assertEquals((long)data.size(), (long)exp.size());
                for (String key : exp.keySet()) {
                    Assert.assertEquals((Object)data.get(key), exp.get(key));
                }
                ++n2;
            }
            ++i2;
        }
    }

    @Test
    public void testBatchDataManager() throws IOException {
        BatchRunDataSetManager manager = new BatchRunDataSetManager();
        manager.clearDataSets();
        ArrayList<NonAggregateDataSource> sources = new ArrayList<NonAggregateDataSource>();
        sources.add(manager.getBatchRunDataSource());
        sources.add(manager.getRandomSeedDataSource());
        sources.add(manager.getTickCountDataSource());
        sources.add(new MethodDataSource("double", ObjectB.class, "getDouble"));
        sources.add(new MethodDataSource("object", ObjectB.class, "object"));
        sources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        ArrayList<DataSink> sinks = new ArrayList<DataSink>();
        String filename = "./test_output/batch_manager_test.txt";
        File file = new File(filename);
        FileDataSink fsink = new FileDataSink("fs1", file, new TabularFormatter(sources, ","));
        sinks.add(fsink);
        Sink sink1 = new Sink();
        sinks.add(sink1);
        NonAggregateDataSet set1 = new NonAggregateDataSet("ds1", sources, sinks);
        manager.addDataSet(set1, ScheduleParameters.createRepeating((double)1.0, (double)1.0), false);
        sinks = new ArrayList();
        Sink sink2 = new Sink();
        sinks.add(sink2);
        NonAggregateDataSet set2 = new NonAggregateDataSet("ds2", sources, sinks);
        manager.addDataSet(set2, ScheduleParameters.createRepeating((double)1.0, (double)1.0), false);
        RunState runState = this.createRunState(1, null);
        manager.batchStarted();
        int r = 0;
        while (r < 3) {
            runState = this.createRunState(r + 1, runState);
            ISchedule schedule = runState.getScheduleRegistry().getModelSchedule();
            List<ObjectB> objs = this.createObjs();
            DefaultContext context = new DefaultContext((Object)"root");
            context.addAll(objs);
            runState.setMasterContext((Context)context);
            manager.runStarted(runState, "root", this.createParameters());
            Assert.assertEquals((Object)manager.getRandomSeedDataSource().get(null), (Object)1);
            Assert.assertEquals((Object)manager.getRandomSeedDataSource().get(new ArrayList()), (Object)1);
            int i = 0;
            while (i < 3) {
                schedule.execute();
                for (ObjectB objB : objs) {
                    objB.setInt(i);
                }
                ++i;
            }
            manager.runEnded(runState, "root");
            ++r;
        }
        manager.batchEnded();
        this.testBatchSinks(filename, sink1, sink2);
    }

    private void testBatchSinks(String fileName, Sink sink1, Sink sink2) throws IOException {
        Sink[] sinks = new Sink[]{sink1, sink2};
        List<String> found = this.readLines(fileName);
        List<String> expectedLines = this.readLines("./test_output/batch_expected.txt");
        Assert.assertEquals((long)found.size(), (long)expectedLines.size());
        int i = 0;
        while (i < found.size()) {
            Assert.assertEquals((Object)found.get(i), (Object)expectedLines.get(i));
            ++i;
        }
        ArrayList expected = new ArrayList();
        int i2 = 1;
        while (i2 < found.size()) {
            String[] vals = found.get(i2).split(",");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("run", Integer.valueOf(vals[0]));
            map.put("random_seed", Integer.valueOf(vals[1]));
            map.put("tick", Double.valueOf(vals[2]));
            map.put("double", Double.valueOf(vals[3]));
            map.put("object", vals[4].substring(1, vals[4].length() - 1));
            map.put("int", Integer.valueOf(vals[5]));
            expected.add(map);
            ++i2;
        }
        Assert.assertEquals((long)sink1.items.size(), (long)36L);
        Assert.assertEquals((long)sink2.items.size(), (long)36L);
        Assert.assertEquals((long)expected.size(), (long)36L);
        i2 = 0;
        while (i2 < 9) {
            Sink[] sinkArray = sinks;
            int n = sinks.length;
            int n2 = 0;
            while (n2 < n) {
                Sink sink = sinkArray[n2];
                Map<String, Object> data = sink.items.get(i2);
                Map exp = (Map)expected.get(i2);
                Assert.assertEquals((long)data.size(), (long)exp.size());
                for (String key : exp.keySet()) {
                    Assert.assertEquals((Object)data.get(key), exp.get(key));
                }
                ++n2;
            }
            ++i2;
        }
    }

    @Test
    public void testParameterSource() {
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("intP", Integer.TYPE, (Object)3, false);
        creator.addParameter("stringP", String.class, (Object)"hello", true);
        Parameters params = creator.createParameters();
        RunEnvironment.init(null, null, (Parameters)params, (boolean)true);
        ArrayList<AggregateDataSource> sources = new ArrayList<AggregateDataSource>();
        sources.add(new ParameterDataSource("intP"));
        sources.add(new ParameterDataSource("stringP"));
        ArrayList<Sink> sinks = new ArrayList<Sink>();
        sinks.add(new Sink());
        AggregateDataSet set1 = new AggregateDataSet("ds1", sources, sinks);
        HashMap objs = new HashMap();
        objs.put(Void.TYPE, NULL_SIZED_ITERABLE);
        set1.init();
        set1.record(objs);
        set1.record(objs);
        set1.close();
        Sink sink = (Sink)sinks.get(0);
        for (Map<String, Object> items : sink.items) {
            Assert.assertEquals((Object)new Integer(3), (Object)items.get("intP"));
            Assert.assertEquals((Object)"hello", (Object)items.get("stringP"));
        }
        ArrayList<NonAggregateDataSource> naSources = new ArrayList<NonAggregateDataSource>();
        naSources.add(new ParameterDataSource("intP"));
        naSources.add(new ParameterDataSource("stringP"));
        naSources.add(new MethodDataSource("int", ObjectB.class, "getInt"));
        ArrayList<FormattingSink> fSinks = new ArrayList<FormattingSink>();
        fSinks.add(new FormattingSink(naSources));
        NonAggregateDataSet set2 = new NonAggregateDataSet("ds1", naSources, fSinks);
        ArrayList<ObjectB> agents = new ArrayList<ObjectB>();
        agents.add(new ObjectB());
        set2.init();
        set2.record(this.createRecordMap(agents, ObjectB.class));
        set2.record(this.createRecordMap(agents, ObjectB.class));
        set2.close();
        FormattingSink fSink = (FormattingSink)fSinks.get(0);
        Assert.assertEquals((long)2L, (long)fSink.items.size());
        for (String item : fSink.items) {
            Assert.assertEquals((Object)"3,\"hello\",3", (Object)item);
            Assert.assertEquals((Object)"3,\"hello\",3", (Object)item);
        }
    }

    class FormattingSink
    implements DataSink {
        TabularFormatter formatter;
        List<String> items = new ArrayList<String>();

        public FormattingSink(List<? extends DataSource> sources) {
            this.formatter = new TabularFormatter(sources, ",");
        }

        @Override
        public void open(List<String> ids) {
        }

        @Override
        public void rowStarted() {
        }

        @Override
        public void append(String key, Object value) {
            this.formatter.addData(key, value);
        }

        @Override
        public void rowEnded() {
            this.items.add(this.formatter.formatData());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void recordEnded() {
        }
    }

    class Sink
    implements DataSink {
        boolean opened = false;
        boolean closed = false;
        List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();

        Sink() {
        }

        @Override
        public void open(List<String> ids) {
            this.opened = true;
        }

        @Override
        public void rowStarted() {
            this.items.add(new HashMap());
        }

        @Override
        public void append(String key, Object value) {
            this.items.get(this.items.size() - 1).put(key, value);
        }

        @Override
        public void rowEnded() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public void recordEnded() {
        }
    }
}

