/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.io.PrintStream;
import java.util.List;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.Formatter;

public class ConsoleDataSink
implements DataSink {
    private PrintStream stream;
    private Formatter formatter;

    public ConsoleDataSink(OutputStream outputStream, Formatter formatter) {
        this.formatter = formatter;
        this.stream = outputStream == OutputStream.OUT ? System.out : System.err;
    }

    @Override
    public void open(List<String> sourceIds) {
        String header = this.formatter.getHeader();
        if (header.length() > 0) {
            this.stream.println(header);
        }
    }

    @Override
    public void flush() {
        this.stream.flush();
    }

    @Override
    public void rowStarted() {
        this.formatter.clear();
    }

    @Override
    public void append(String key, Object value) {
        this.formatter.addData(key, value);
    }

    @Override
    public void rowEnded() {
        this.stream.println(this.formatter.formatData());
    }

    @Override
    public void recordEnded() {
    }

    @Override
    public void close() {
        this.stream.flush();
    }

    public static enum OutputStream {
        OUT,
        ERR;

    }
}

