/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.BatchRunDataSource;
import repast.simphony.data2.DataException;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.Formatter;
import repast.simphony.data2.LineFormatter;
import repast.simphony.data2.ParameterDataSource;
import repast.simphony.data2.TabularFormatter;
import repast.simphony.data2.builder.FileNameFormatter;
import repast.simphony.data2.util.DataUtilities;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.parameter.Parameters;

public class BatchParamMapFileWriter
implements DataSink {
    private Formatter formatter;
    private BufferedWriter writer;
    private FileNameFormatter fnFormatter;
    private String delimiter;
    private FormatType formatType;
    private AggregateDataSource batchRunDS;
    private List<AggregateDataSource> sources;
    private Updater updater = new Updater();
    private boolean closed = false;

    public BatchParamMapFileWriter(BatchRunDataSource source, FileNameFormatter fnFormatter, String delimiter, FormatType formatType) {
        this.fnFormatter = fnFormatter;
        this.batchRunDS = source;
        this.formatType = formatType;
        this.delimiter = delimiter;
    }

    @Override
    public final void open(List<String> sourceIds) {
    }

    private void init() {
        this.sources = new ArrayList<AggregateDataSource>();
        this.sources.add(this.batchRunDS);
        Parameters params = RunEnvironment.getInstance().getParameters();
        for (String pName : params.getSchema().parameterNames()) {
            if (pName.equals("repast.simphony.batch.BatchConstantsbatch.name")) continue;
            ParameterDataSource ds = new ParameterDataSource(pName);
            this.sources.add(ds);
        }
        this.formatter = this.formatType == FormatType.TABULAR ? new TabularFormatter(this.sources, this.delimiter) : new LineFormatter(this.sources, this.delimiter);
        try {
            String file = this.fnFormatter.getFilename("batch_param_map");
            DataUtilities.renameFileIfExists(file);
            this.writer = new BufferedWriter(new FileWriter(file));
            String header = this.formatter.getHeader();
            if (header.length() > 0) {
                this.writer.write(this.formatter.getHeader());
                this.writer.newLine();
                this.writer.flush();
            }
        }
        catch (IOException ex) {
            throw new DataException("Error opening BatchParamMapFileWriter.", ex);
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.closed) {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
            }
            catch (IOException ex) {
                throw new DataException("Error while flushing BatchParamMapFileWriter.", ex);
            }
        }
    }

    public void runStarted() {
        this.updater = new OneTimeUpdater();
    }

    private void write() {
        if (this.formatter == null) {
            this.init();
        }
        for (AggregateDataSource source : this.sources) {
            this.formatter.addData(source.getId(), source.get(null, 0));
        }
        try {
            this.writer.write(this.formatter.formatData());
            this.writer.newLine();
        }
        catch (IOException ex) {
            throw new DataException("Error writing to BatchParamMap", ex);
        }
    }

    @Override
    public final void rowStarted() {
    }

    @Override
    public final void append(String key, Object value) {
    }

    @Override
    public final void rowEnded() {
        this.updater.update();
    }

    @Override
    public final void recordEnded() {
    }

    @Override
    public synchronized void close() {
        if (!this.closed && this.writer != null) {
            try {
                try {
                    this.writer.flush();
                }
                catch (IOException ex) {
                    throw new DataException("Error closing BatchParamMapFileWriter.", ex);
                }
            }
            finally {
                try {
                    this.closed = true;
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class OneTimeUpdater
    extends Updater {
        private OneTimeUpdater() {
            super(null, null);
        }

        @Override
        public void update() {
            BatchParamMapFileWriter.this.write();
            BatchParamMapFileWriter.this.updater = new Updater();
        }
    }

    private class Updater {
        private Updater() {
        }

        public void update() {
        }

        /* synthetic */ Updater(Updater updater, Updater updater2) {
            this();
        }
    }
}

