/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import repast.simphony.data2.AbstractDataSet;
import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.SizedIterable;

public class AggregateDataSet
extends AbstractDataSet {
    private List<AggregateDataSource> sources = new ArrayList<AggregateDataSource>();
    private List<Class<?>> targetTypes = new ArrayList();

    public AggregateDataSet(String id, Collection<AggregateDataSource> sources, Collection<? extends DataSink> sinks) {
        super(id);
        this.sources.addAll(sources);
        this.sinks.addAll(sinks);
        for (DataSource dataSource : sources) {
            this.targetTypes.add(dataSource.getSourceType());
        }
    }

    @Override
    protected List<String> getSourceIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (AggregateDataSource source : this.sources) {
            ids.add(source.getId());
        }
        return ids;
    }

    @Override
    public Iterable<Class<?>> getSourceTypes() {
        return this.targetTypes;
    }

    @Override
    public void record(Map<Class<?>, SizedIterable<?>> objMap) {
        for (DataSink sink : this.sinks) {
            sink.rowStarted();
        }
        for (AggregateDataSource source : this.sources) {
            source.reset();
        }
        for (AggregateDataSource source : this.sources) {
            String id = source.getId();
            SizedIterable<?> objs = objMap.get(source.getSourceType());
            Object val = source.get(objs, objs.size());
            for (DataSink sink : this.sinks) {
                sink.append(id, val);
            }
        }
        for (DataSink sink : this.sinks) {
            sink.rowEnded();
            sink.recordEnded();
        }
    }
}

