/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.Formatter;

public abstract class AbstractFormatter
implements Formatter {
    protected Map<String, ItemFormatter> keyMap = new LinkedHashMap<String, ItemFormatter>();
    protected String[] data;
    protected String delimiter;

    public AbstractFormatter(Collection<? extends DataSource> sources, String delimiter) {
        this.delimiter = delimiter;
        int i = 0;
        for (DataSource dataSource : sources) {
            if (dataSource.getDataType().equals(Object.class)) {
                this.keyMap.put(dataSource.getId(), new RuntimeTestFormatter(this.keyMap, dataSource.getId(), i));
            } else if (Number.class.isAssignableFrom(dataSource.getDataType())) {
                this.keyMap.put(dataSource.getId(), new ItemFormatter(i));
            } else {
                this.keyMap.put(dataSource.getId(), new StringFormatter(i));
            }
            ++i;
        }
        this.data = new String[this.keyMap.size()];
        Arrays.fill(this.data, "");
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, "");
    }

    @Override
    public void addData(String id, Object obj) {
        ItemFormatter formatter = this.keyMap.get(id);
        if (formatter != null) {
            formatter.format(obj, this.data);
        }
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected static class ItemFormatter {
        public int index;

        public ItemFormatter(int index) {
            this.index = index;
        }

        public void format(Object obj, String[] data) {
            data[this.index] = obj.toString();
        }
    }

    protected static class RuntimeTestFormatter
    extends ItemFormatter {
        Map<String, ItemFormatter> keyMap;
        String id;

        public RuntimeTestFormatter(Map<String, ItemFormatter> keyMap, String id, int index) {
            super(index);
            this.keyMap = keyMap;
            this.id = id;
        }

        @Override
        public void format(Object obj, String[] data) {
            ItemFormatter formatter = Number.class.isAssignableFrom(obj.getClass()) ? new ItemFormatter(this.index) : new StringFormatter(this.index);
            formatter.format(obj, data);
            this.keyMap.put(this.id, formatter);
        }
    }

    protected static class StringFormatter
    extends ItemFormatter {
        public StringFormatter(int index) {
            super(index);
        }

        @Override
        public void format(Object obj, String[] data) {
            StringBuilder builder = new StringBuilder("\"");
            builder.append(obj.toString());
            builder.append("\"");
            data[this.index] = builder.toString();
        }
    }
}

