/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import repast.simphony.context.Context;
import repast.simphony.context.ContextEvent;
import repast.simphony.context.ContextListener;
import repast.simphony.data2.BatchRunDataSource;
import repast.simphony.data2.DataSet;
import repast.simphony.data2.DataSetManager;
import repast.simphony.data2.RandomSeedDataSource;
import repast.simphony.data2.SizedIterable;
import repast.simphony.data2.TickCountDataSource;
import repast.simphony.data2.builder.DataSetBuilder;
import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.NonModelAction;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.parameter.Parameters;

public abstract class AbstractDataSetManager
implements DataSetManager,
RunListener {
    private static SizedIterable<Object> NULL_SIZED_ITERABLE = new SizedIterable<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return null;
        }
    };
    private TickCountDataSource tickCountDataSource;
    private RandomSeedDataSource rndSeedDataSource;
    private BatchRunDataSource batchRunDataSource;
    protected Map<String, DataSetBuilder<?>> builders = new HashMap();
    protected List<ScheduledDataSet> dataSets = new ArrayList<ScheduledDataSet>();

    public AbstractDataSetManager() {
        this.tickCountDataSource = new TickCountDataSource();
        this.rndSeedDataSource = new RandomSeedDataSource();
        this.batchRunDataSource = new BatchRunDataSource();
    }

    @Override
    public BatchRunDataSource getBatchRunDataSource() {
        return this.batchRunDataSource;
    }

    @Override
    public TickCountDataSource getTickCountDataSource() {
        return this.tickCountDataSource;
    }

    @Override
    public RandomSeedDataSource getRandomSeedDataSource() {
        return this.rndSeedDataSource;
    }

    @Override
    public void addDataSet(DataSet dataSet, ScheduleParameters scheduleParams, boolean atEnd) {
        this.dataSets.add(new ScheduledDataSet(dataSet, scheduleParams, atEnd));
    }

    @Override
    public void flush() {
        for (ScheduledDataSet dataSet : this.dataSets) {
            dataSet.dataSet.flush();
        }
    }

    public void clearDataSets() {
        this.dataSets.clear();
    }

    @Override
    public void runStarted(RunState runState, Object contextId, Parameters parameters) {
        runState.getScheduleRegistry().getScheduleRunner().addRunListener((RunListener)this);
        this.tickCountDataSource.resetSchedule(runState.getScheduleRegistry().getModelSchedule());
        this.rndSeedDataSource.resetSeed((Integer)parameters.getValue("randomSeed"));
        this.batchRunDataSource.resetBatchRun(runState.getRunInfo().getRunNumber());
        HashMap listMap = new HashMap();
        Context context = runState.getMasterContext().findContext(contextId);
        for (ScheduledDataSet source : this.dataSets) {
            for (Class<?> sourceType : source.dataSet.getSourceTypes()) {
                if (!listMap.containsKey(sourceType)) {
                    if (sourceType.equals(Void.TYPE)) {
                        listMap.put(sourceType, NULL_SIZED_ITERABLE);
                    } else {
                        ObjList list = new ObjList(sourceType);
                        list.init(context);
                        listMap.put(sourceType, list);
                    }
                }
                source.objMap = listMap;
            }
            ISchedule schedule = runState.getScheduleRegistry().getModelSchedule();
            schedule.schedule(source.scheduleParams, (IAction)source);
            if (!source.atEnd) continue;
            schedule.schedule(ScheduleParameters.createAtEnd((double)Double.NEGATIVE_INFINITY), (IAction)source);
        }
    }

    @Override
    public void runEnded(RunState runState, Object contextId) {
        runState.getScheduleRegistry().getScheduleRunner().removeRunListener((RunListener)this);
        for (ScheduledDataSet source : this.dataSets) {
            source.reset(runState.getMasterContext());
        }
    }

    @Override
    public void addDataSetBuilder(DataSetBuilder<?> builder) {
        this.builders.put(builder.getId(), builder);
    }

    @Override
    public DataSetBuilder<?> getDataSetBuilder(String id) {
        return this.builders.get(id);
    }

    public void stopped() {
        this.flush();
    }

    public void paused() {
        this.flush();
    }

    public void started() {
    }

    public void restarted() {
    }

    protected static class ObjList
    implements ContextListener,
    SizedIterable<Object> {
        Class<?> targetType;
        Set<Object> objs = new HashSet<Object>();

        public ObjList(Class<?> targetType) {
            this.targetType = targetType;
        }

        void init(Context<?> context) {
            if (this.targetType.isAssignableFrom(context.getClass())) {
                this.objs.add(context);
            } else {
                for (Object obj : context) {
                    if (!this.targetType.isAssignableFrom(obj.getClass())) continue;
                    this.objs.add(obj);
                }
            }
            context.addContextListener((ContextListener)this);
        }

        void reset(Context<?> context) {
            context.removeContextListener((ContextListener)this);
            this.objs.clear();
        }

        public void eventOccured(ContextEvent ev) {
            boolean isMatch = this.targetType.isAssignableFrom(ev.getTarget().getClass());
            if (isMatch) {
                if (ev.getType() == ContextEvent.ADDED) {
                    this.objs.add(ev.getTarget());
                } else if (ev.getType() == ContextEvent.REMOVED) {
                    this.objs.remove(ev.getTarget());
                }
            }
        }

        @Override
        public int size() {
            return this.objs.size();
        }

        @Override
        public Iterator<Object> iterator() {
            return this.objs.iterator();
        }
    }

    @NonModelAction
    protected static class ScheduledDataSet
    implements IAction {
        DataSet dataSet;
        ScheduleParameters scheduleParams;
        Map<Class<?>, SizedIterable<?>> objMap;
        boolean atEnd;

        ScheduledDataSet(DataSet set, ScheduleParameters scheduleParams, boolean atEnd) {
            this.dataSet = set;
            this.scheduleParams = scheduleParams;
            this.atEnd = atEnd;
        }

        void reset(Context<?> context) {
            for (SizedIterable<?> si : this.objMap.values()) {
                if (!(si instanceof ObjList)) continue;
                ((ObjList)si).reset(context);
            }
        }

        public void execute() {
            this.dataSet.record(this.objMap);
        }
    }
}

