/*
 * Decompiled with CFR 0.152.
 */
package util.fn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import util.Pair;
import util.fn.Lambda;
import util.fn.Lambda2;

public class FnIterable<T>
implements Iterable<T> {
    private final Iterable<T> it;

    private FnIterable(Iterable<T> it) {
        this.it = it;
    }

    public static <T> FnIterable<T> from(Iterable<T> it) {
        return new FnIterable<T>(it);
    }

    public final <U> FnIterable<Pair<T, U>> zip(final FnIterable<U> o) {
        return new FnIterable<Pair<T, U>>(new Iterable<Pair<T, U>>(){

            @Override
            public Iterator<Pair<T, U>> iterator() {
                final Iterator inner1 = FnIterable.this.it.iterator();
                final Iterator inner2 = o.iterator();
                return new Iterator<Pair<T, U>>(){

                    @Override
                    public boolean hasNext() {
                        return inner1.hasNext() || inner2.hasNext();
                    }

                    @Override
                    public Pair<T, U> next() {
                        Object o1 = inner1.hasNext() ? (Object)inner1.next() : null;
                        Object o2 = inner2.hasNext() ? (Object)inner2.next() : null;
                        return new Pair<Object, Object>(o1, o2);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public final <U> FnIterable<U> map(final Lambda<T, U> fn) {
        return new FnIterable<T>(new Iterable<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator inner = FnIterable.this.it.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return inner.hasNext();
                    }

                    @Override
                    public U next() {
                        return fn.call(inner.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public final <U> U reduce(Lambda2<U, T, U> fn, U initial) {
        for (T item : this) {
            initial = fn.call(initial, item);
        }
        return initial;
    }

    public final List<T> toList() {
        ArrayList<T> retval = new ArrayList<T>();
        for (T item : this) {
            retval.add(item);
        }
        return retval;
    }

    @Override
    public Iterator<T> iterator() {
        return this.it.iterator();
    }
}

