/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public final class ThreadTimer {
    private static final List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();

    public static Tick tick() {
        return new Tick();
    }

    public static class Tick {
        private long sysTime;
        private long gcTime;

        private Tick() {
            long gcCountEnd;
            long gcCountBegin;
            do {
                gcCountBegin = this.numGCs();
                this.sysTime = this.milliTime();
                this.gcTime = this.milliGcTime();
            } while (gcCountBegin != (gcCountEnd = this.numGCs()));
        }

        public long elapsedTime(boolean withoutGc, Tick end) {
            return end.sysTime - this.sysTime - (withoutGc ? end.gcTime - this.gcTime : 0L);
        }

        private long milliTime() {
            return System.nanoTime() / 1000000L;
        }

        private long milliGcTime() {
            long result = 0L;
            for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
                result += Math.max(0L, garbageCollectorMXBean.getCollectionTime());
            }
            return result;
        }

        private long numGCs() {
            long result = 0L;
            for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
                result += garbageCollectorMXBean.getCollectionCount();
            }
            return result;
        }
    }
}

