/*
 * Decompiled with CFR 0.152.
 */
package util;

public class SystemProperties {
    public static <T extends Enum<T>> T getEnumProperty(String name, Class<T> enumType, T def) {
        String value = System.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException iae) {
            return def;
        }
    }

    public static int getIntProperty(String name, int def) {
        return Integer.getInteger(name, def);
    }

    public static long getLongProperty(String name, long def) {
        return Long.getLong(name, def);
    }

    public static double getDoubleProperty(String name, double def) {
        String value = System.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public static boolean getBooleanProperty(String name, boolean def) {
        String value = System.getProperty(name);
        if (value == null) {
            return def;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return def;
    }
}

