/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import util.CollectionMath;
import util.fn.FnIterable;
import util.fn.Lambda;

public abstract class Statistics {
    public abstract void dumpSummary(PrintStream var1);

    public abstract void dumpFull(PrintStream var1);

    public abstract void merge(Object var1);

    protected final void printFullHeader(PrintStream out, String header) {
        out.printf("==== %s ====\n", header);
    }

    protected final void printSummaryHeader(PrintStream out, String header) {
        out.printf("%s: ", header);
    }

    protected final void summarizeInts(PrintStream out, Collection<Integer> list, String prefix) {
        this.summarizeInts(out, list, 0, prefix);
    }

    protected final void summarizeInts(PrintStream out, Collection<Integer> list, int drop, String prefix) {
        float[] stats = this.summarizeInts(list, drop);
        if (stats == null) {
            return;
        }
        if (stats[4] != (float)list.size()) {
            prefix = String.format("%sDrop first %.0f: ", prefix, Float.valueOf((float)list.size() - stats[4]));
        }
        out.printf("%smean: %.2f min: %.0f max: %.0f stdev: %.2f\n", prefix, Float.valueOf(stats[0]), Float.valueOf(stats[1]), Float.valueOf(stats[2]), Math.sqrt(stats[3]));
    }

    protected final float[] summarizeInts(Collection<Integer> list, int drop) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() <= 1 + drop) {
            drop = 0;
        }
        List<Integer> retain = new ArrayList<Integer>(list).subList(drop, list.size());
        final float mean = (float)CollectionMath.sumInteger(retain).intValue() / (float)retain.size();
        int min = Collections.min(retain);
        int max = Collections.max(retain);
        float var = CollectionMath.sumFloat(FnIterable.from(retain).map(new Lambda<Integer, Float>(){

            @Override
            public Float call(Integer x) {
                return Float.valueOf(((float)x.intValue() - mean) * ((float)x.intValue() - mean));
            }
        })).floatValue() / (float)(retain.size() - 1);
        float[] retval = new float[]{mean, min, max, var, retain.size()};
        return retval;
    }

    protected final void summarizeLongs(PrintStream out, Collection<Long> list, String prefix) {
        this.summarizeLongs(out, list, 0, prefix);
    }

    protected final void summarizeLongs(PrintStream out, Collection<Long> list, int drop, String prefix) {
        this.summarizeLongs(out, list, drop, prefix, false);
    }

    protected final void summarizeLongs(PrintStream out, Collection<Long> list, int drop, String prefix, boolean suppressNewline) {
        float[] stats = this.summarizeLongs(list, drop);
        if (stats == null) {
            return;
        }
        if (stats[4] != (float)list.size()) {
            prefix = String.format("%sDrop first %.0f: ", prefix, Float.valueOf((float)list.size() - stats[4]));
        }
        out.printf("%smean: %.2f min: %.0f max: %.0f stdev: %.2f", prefix, Float.valueOf(stats[0]), Float.valueOf(stats[1]), Float.valueOf(stats[2]), Math.sqrt(stats[3]));
        if (!suppressNewline) {
            out.println();
        }
    }

    protected final float[] summarizeLongs(Collection<Long> list, int drop) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() <= 1 + drop) {
            drop = 0;
        }
        List<Long> retain = new ArrayList<Long>(list).subList(drop, list.size());
        final float mean = (float)CollectionMath.sumLong(retain).longValue() / (float)retain.size();
        long min = Collections.min(retain);
        long max = Collections.max(retain);
        float var = CollectionMath.sumFloat(FnIterable.from(retain).map(new Lambda<Long, Float>(){

            @Override
            public Float call(Long x) {
                return Float.valueOf(((float)x.longValue() - mean) * ((float)x.longValue() - mean));
            }
        })).floatValue() / (float)(retain.size() - 1);
        float[] retval = new float[]{mean, min, max, var, retain.size()};
        return retval;
    }

    protected final void summarizeFloats(PrintStream out, Collection<Float> list, String prefix) {
        this.summarizeFloats(out, list, 0, prefix);
    }

    protected final void summarizeFloats(PrintStream out, Collection<Float> list, int drop, String prefix) {
        float[] stats = this.summarizeFloats(list, drop);
        if (stats == null) {
            return;
        }
        if (stats[4] != (float)list.size()) {
            prefix = String.format("%sDrop first %d: ", prefix, Float.valueOf((float)list.size() - stats[4]));
        }
        out.printf("%smean: %.4f min: %.4f max: %.4f stdev: %.3f\n", prefix, Float.valueOf(stats[0]), Float.valueOf(stats[1]), Float.valueOf(stats[2]), Math.sqrt(stats[3]));
    }

    protected final float[] summarizeFloats(Collection<Float> list, int drop) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() <= 1 + drop) {
            drop = 0;
        }
        List<Float> retain = new ArrayList<Float>(list).subList(drop, list.size());
        final float mean = CollectionMath.sumFloat(retain).floatValue() / (float)retain.size();
        float min = Collections.min(retain).floatValue();
        float max = Collections.max(retain).floatValue();
        float var = CollectionMath.sumFloat(FnIterable.from(retain).map(new Lambda<Float, Float>(){

            @Override
            public Float call(Float x) {
                return Float.valueOf((x.floatValue() - mean) * (x.floatValue() - mean));
            }
        })).floatValue() / (float)(retain.size() - 1);
        float[] retval = new float[]{mean, min, max, var, retain.size()};
        return retval;
    }
}

