/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import util.Statistics;

public class StackStatistics
extends Statistics {
    private final Map<Thread, List<StackTraceElement[]>> threadStacks;

    public StackStatistics(Map<Thread, List<StackTraceElement[]>> threadStacks) {
        this.threadStacks = threadStacks;
    }

    @Override
    public void dumpFull(PrintStream out) {
        this.printFullHeader(out, "Stacks (top ten)");
        this.printTop(out);
        this.printFullHeader(out, "Stacks");
        for (List<StackTraceElement[]> stacks : this.threadStacks.values()) {
            for (StackTraceElement[] stack : stacks) {
                int i = 0;
                while (i < stack.length) {
                    out.println(stack[i]);
                    ++i;
                }
                out.println();
            }
        }
    }

    @Override
    public void dumpSummary(PrintStream out) {
        this.printSummaryHeader(out, "Stacks (top ten)");
        out.println();
        this.printTop(out);
    }

    private void printTop(PrintStream out) {
        HashMap<String, Integer> selfCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> totalCounts = new HashMap<String, Integer>();
        int totalSamples = 0;
        HashSet<String> seen = new HashSet<String>();
        for (List<StackTraceElement[]> stacks : this.threadStacks.values()) {
            totalSamples += stacks.size();
            for (StackTraceElement[] stack : stacks) {
                int stopIndex = -1;
                int i = stack.length - 1;
                while (i >= 0) {
                    String methodName = stack[i].getMethodName();
                    if (methodName.startsWith("__stackSamplerRecordMe")) {
                        stopIndex = i;
                        break;
                    }
                    --i;
                }
                if (stopIndex < 0) continue;
                i = 0;
                while (i < stopIndex) {
                    String key = String.format("%s.%s", stack[i].getClassName(), stack[i].getMethodName());
                    if (!seen.contains(key)) {
                        if (i == 0) {
                            StackStatistics.addOne(selfCounts, key);
                        }
                        StackStatistics.addOne(totalCounts, key);
                        seen.add(key);
                    }
                    ++i;
                }
                seen.clear();
            }
        }
        out.println("  Self:");
        this.dumpTop(out, selfCounts, totalSamples, "    ");
        out.println("  Total:");
        this.dumpTop(out, totalCounts, totalSamples, "    ");
    }

    @Override
    public void merge(Object obj) {
        StackStatistics other = (StackStatistics)obj;
        for (Map.Entry<Thread, List<StackTraceElement[]>> entry : other.threadStacks.entrySet()) {
            List<StackTraceElement[]> value = this.threadStacks.get(entry.getKey());
            if (value == null) {
                value = new ArrayList<StackTraceElement[]>();
                this.threadStacks.put(entry.getKey(), value);
            }
            value.addAll((Collection<StackTraceElement[]>)entry.getValue());
        }
    }

    private void dumpTop(PrintStream out, Map<String, Integer> counts, int totalSamples, String prefix) {
        int count = 0;
        for (String method : StackStatistics.descendingOrder(counts)) {
            float ratio = (float)counts.get(method).intValue() / (float)totalSamples;
            if (count++ > 10 || !((double)ratio > 0.05)) break;
            out.printf("%s%s %.3f\n", prefix, method, Float.valueOf(ratio));
        }
    }

    private static void addOne(Map<String, Integer> map, String key) {
        Integer value = map.get(key);
        if (value == null) {
            map.put(key, 1);
        } else {
            map.put(key, value + 1);
        }
    }

    private static List<String> descendingOrder(final Map<String, Integer> map) {
        ArrayList<String> methods = new ArrayList<String>(map.keySet());
        Collections.sort(methods, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return (Integer)map.get(arg1) - (Integer)map.get(arg0);
            }
        });
        return methods;
    }
}

