/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.Sampler;
import util.StackStatistics;

public class StackSampler
extends Sampler {
    private final Deque<Map<Thread, StackTraceElement[]>> samples = new ArrayDeque<Map<Thread, StackTraceElement[]>>();
    public static final String includeMethodName = "__stackSamplerRecordMe";

    protected StackSampler(int intervalMillis) {
        super(intervalMillis);
    }

    @Override
    protected void sample() {
        this.samples.add(Thread.getAllStackTraces());
    }

    private Map<Thread, List<StackTraceElement[]>> getSamples() {
        HashMap<Thread, List<StackTraceElement[]>> retval = new HashMap<Thread, List<StackTraceElement[]>>();
        for (Map<Thread, StackTraceElement[]> sample : this.samples) {
            for (Map.Entry<Thread, StackTraceElement[]> entry : sample.entrySet()) {
                Thread t = entry.getKey();
                StackTraceElement[] stack = entry.getValue();
                boolean keep = false;
                int i = 0;
                while (i < stack.length) {
                    if (stack[i].getMethodName().startsWith(includeMethodName)) {
                        keep = true;
                    }
                    ++i;
                }
                if (!keep) continue;
                ArrayList<StackTraceElement[]> list = (ArrayList<StackTraceElement[]>)retval.get(t);
                if (list == null) {
                    list = new ArrayList<StackTraceElement[]>();
                    retval.put(t, list);
                }
                list.add(stack);
            }
        }
        return retval;
    }

    @Override
    protected StackStatistics dumpSamples() {
        return new StackStatistics(this.getSamples());
    }

    public static Sampler start(int interval) {
        return StackSampler.start(new StackSampler(interval));
    }
}

