/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class InputOutput {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static Collection<String> getFilePathsMatching(String directory, final String suffix) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(suffix);
            }
        };
        return InputOutput.getFilePaths(directory, filter);
    }

    public static Collection<String> getFilePathsEndingWith(String directory, final String suffix) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix);
            }
        };
        return InputOutput.getFilePaths(directory, filter);
    }

    public static Collection<String> getFilePathsStartingWith(String directory, final String prefix) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        };
        return InputOutput.getFilePaths(directory, filter);
    }

    private static Collection<String> getFilePaths(String directory, FilenameFilter filter) {
        File inputDirectory = new File(directory);
        String[] children = inputDirectory.list(filter);
        if (children == null) {
            throw new RuntimeException("Input directory: " + inputDirectory + " does not exist or is not a directory.");
        }
        List<String> result = Arrays.asList(children);
        Collections.sort(result);
        int i = 0;
        while (i < result.size()) {
            String fullPath = String.valueOf(directory) + "/" + result.get(i);
            result.set(i, fullPath);
            ++i;
        }
        return result;
    }

    public static void write(String filePath, String text) throws IOException {
        InputOutput.write(filePath, text, true);
    }

    public static void write(String filePath, String text, boolean append) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filePath, append));
        out.write(text);
        out.close();
    }
}

